/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.configuration.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.aspectj.configuration.model.Aspect;
import org.aspectj.configuration.model.Expression;
import org.aspectj.configuration.model.GlobalContext;
import org.aspectj.util.Utils;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Configuration {
    private Map<String, String[]> aspectByInstance;
    private Collection<Aspect> aspects;
    private GlobalContext globalContext;
    private volatile transient VariableResolverFactory globalResolver;

    Configuration() {
    }

    public Configuration(Map<String, String[]> aspectByInstance, Collection<Aspect> aspects, GlobalContext globalContext) {
        this.aspectByInstance = aspectByInstance;
        this.aspects = aspects;
        this.globalContext = globalContext;
    }

    public Collection<Aspect> currentAspects(String filter) {
        if (filter == null || filter.isEmpty()) {
            return this.aspects;
        }
        String[] aspectsRefs = this.aspectByInstance.get(filter);
        if (aspectsRefs == null || aspectsRefs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Aspect> filtredAspects = new ArrayList<Aspect>();
        for (Aspect aspect : this.aspects) {
            String aspectName = aspect.getName();
            if (aspectName == null || aspectName.isEmpty()) continue;
            for (String name : aspectsRefs) {
                if (name == null || name.isEmpty() || !name.equals(aspectName)) continue;
                filtredAspects.add(aspect);
            }
        }
        if (filtredAspects.size() != aspectsRefs.length) {
            throw new IllegalArgumentException("Filtred aspect count " + filtredAspects.size() + ", but reference count " + aspectsRefs.length);
        }
        return filtredAspects;
    }

    public Collection<Aspect> getAllAspects() {
        return this.aspects;
    }

    public Aspect getAspect(String name) {
        for (Aspect aspect : this.aspects) {
            if (!name.equals(aspect.getName())) continue;
            return aspect;
        }
        throw new IllegalArgumentException("Aspect configuration '" + name + "' not found");
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public VariableResolverFactory getGlobalResolver() {
        return this.globalResolver;
    }

    public void setGlobalResolver(VariableResolverFactory globalResolver) {
        this.globalResolver = globalResolver;
    }

    public static void validateConfiguration(Configuration configuration) {
        Collection<Aspect> aspects = configuration.getAllAspects();
        HashSet<String> uniqAspectNames = new HashSet<String>(aspects.size());
        for (Aspect aspect : aspects) {
            if (Utils.isEmpty(aspect.getName())) {
                throw new IllegalArgumentException("Aspect name is empty");
            }
            uniqAspectNames.add(aspect.getName());
            if (Utils.isEmpty(aspect.getPointcut())) {
                throw new IllegalArgumentException("Pointcut expression is empty. Aspect: " + aspect.getName());
            }
            if (aspect.getType() == null) {
                throw new IllegalArgumentException("Type is empty. Aspect: " + aspect.getName());
            }
            Configuration.validateExpression(aspect, aspect.getInit(), "init");
            Configuration.validateExpression(aspect, aspect.getProcess(), "process");
            Configuration.validateExpression(aspect, aspect.getDispose(), "dispose");
        }
        if (uniqAspectNames.size() != aspects.size()) {
            throw new IllegalArgumentException("Unique aspect names: " + uniqAspectNames.size() + ", total aspect count " + aspects.size());
        }
        Map<String, String[]> aspectByInstance = configuration.getAspectByInstance();
        Set<Map.Entry<String, String[]>> entries = aspectByInstance.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            String key = entry.getKey();
            if (Utils.isEmpty(key)) {
                throw new IllegalArgumentException("Key is empty inside aspectByInstance");
            }
            String[] aspectsRef = entry.getValue();
            if (aspectsRef == null || aspectsRef.length == 0) {
                throw new IllegalArgumentException("Value is empty inside aspectByInstance. Key " + key);
            }
            for (String aspect : aspectsRef) {
                if (Utils.isEmpty(aspect)) {
                    throw new IllegalArgumentException("Aspect reference is empty inside aspectByInstance. Key " + key);
                }
                if (uniqAspectNames.contains(aspect)) continue;
                throw new IllegalArgumentException("Aspect not found by by reference '" + aspect + "'");
            }
        }
    }

    private static void validateExpression(Aspect aspect, Expression expression, String expressionName) {
        if (expression != null) {
            if (!Expression.isNotEmptyExpression(expression)) {
                throw new IllegalArgumentException("Empty expression in '" + expressionName + "' Aspect: " + aspect.getName());
            }
            try {
                Utils.compileMvelExpression(expression.getExpression());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid MVEL expression. Aspect '" + aspect.getName() + "', expression: " + expressionName, e);
            }
            try {
                expression.getResultParams();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid parameter value. Aspect '" + aspect.getName() + "', expression: " + expressionName, e);
            }
        }
    }

    public Map<String, String[]> getAspectByInstance() {
        if (this.aspectByInstance == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.aspectByInstance);
    }
}

