/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.configuration.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.aspectj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Expression {
    private String expression;
    private Map<String, String> params;

    Expression() {
    }

    public Expression(String expression) {
        this.expression = expression;
    }

    public Expression(String expression, Map<String, String> params) {
        this.expression = expression;
        this.params = params;
    }

    public boolean isNotEmpty() {
        return Expression.isNotEmptyExpression(this);
    }

    public static boolean isNotEmptyExpression(Expression expression) {
        return expression != null && expression.getExpression() != null && !expression.getExpression().trim().isEmpty();
    }

    public String getExpression() {
        return this.expression;
    }

    public Map<String, Object> getResultParams() {
        if (this.params == null || this.params.size() == 0) {
            return null;
        }
        HashMap<String, Object> resultParams = new HashMap<String, Object>(this.params.size());
        Set<Map.Entry<String, String>> entries = this.params.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String sourceValue = entry.getValue();
            String key = entry.getKey();
            try {
                Object value = Utils.checkMvelExpression(sourceValue);
                resultParams.put(key, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Parameter name '" + key + "'", e);
            }
        }
        return resultParams;
    }
}

