/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import com.github.smreed.dropship.MavenClassLoader;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.logging.Logger;
import org.aspectj.configuration.model.Artifact;
import org.aspectj.configuration.model.Aspect;
import org.aspectj.configuration.model.ClassRef;
import org.aspectj.configuration.model.ResourceRef;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenLoader {
    private static Logger LOGGER = Logger.getLogger(MavenLoader.class.getName());

    public static URLClassLoader getClassLoader(String gav) {
        MavenClassLoader.ClassLoaderBuilder classLoaderBuilder;
        String mavenRepository = System.getProperty("repo.remote.url");
        if (mavenRepository == null || mavenRepository.isEmpty()) {
            LOGGER.info("Using maven central repository");
            classLoaderBuilder = MavenClassLoader.usingCentralRepo();
        } else {
            LOGGER.info("Using maven custom repository: " + mavenRepository);
            classLoaderBuilder = MavenClassLoader.using((String)mavenRepository);
        }
        return classLoaderBuilder.forMavenCoordinates(gav);
    }

    public static Class<?> loadClass(String gav, String className) throws ClassNotFoundException {
        URLClassLoader classLoader = MavenLoader.getClassLoader(gav);
        return classLoader.loadClass(className);
    }

    public static void prefetch(Artifact[] artifacts) {
        if (artifacts == null) {
            return;
        }
        for (Artifact artifact : artifacts) {
            MavenLoader.prefetch(artifact);
        }
    }

    public static void prefetch(Artifact artifact) {
        if (artifact == null) {
            return;
        }
        MavenLoader.getClassLoader(artifact.getArtifact());
    }

    public static void prefetchDependencies(Collection<Aspect> aspects) {
        if (aspects == null) {
            return;
        }
        for (Aspect aspect : aspects) {
            MavenLoader.prefetch(aspect.getArtifacts());
        }
    }

    public static void loadArtifact(Artifact[] artifacts, VariableResolverFactory variableResolverFactory) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                ResourceRef[] resourceRefs;
                URLClassLoader classLoader = MavenLoader.getClassLoader(artifact.getArtifact());
                ClassRef[] classRefs = artifact.getClassRefs();
                if (classRefs != null) {
                    for (ClassRef classRef : classRefs) {
                        String className = classRef.getClassName();
                        try {
                            Class<?> aClass = classLoader.loadClass(className);
                            variableResolverFactory.createVariable(classRef.getVariable(), aClass);
                            variableResolverFactory.createVariable(className, aClass);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Class '" + className + "' not found in artifact: " + artifact.getArtifact());
                        }
                    }
                }
                if ((resourceRefs = artifact.getResourceRefs()) == null) continue;
                for (ResourceRef resourceRef : resourceRefs) {
                    Object resourceStream = resourceRef.isUseUrl() ? classLoader.getResource(resourceRef.getResourceName()) : classLoader.getResourceAsStream(resourceRef.getResourceName());
                    if (resourceStream == null) {
                        throw new IllegalArgumentException("Resource " + resourceRef.getResourceName() + " not found in artifact: " + artifact.getArtifact());
                    }
                    variableResolverFactory.createVariable(resourceRef.getVariable(), resourceStream);
                }
            }
        }
    }
}

