/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.aspectj.configuration.model.Expression;
import org.aspectj.util.MavenLoader;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String CONFIGURATION_PREFIX = "org.aspectj.weaver.loadtime.configuration.";
    public static final String DEBUG_OPTION = "org.aspectj.weaver.loadtime.configuration.debug";
    public static final String CONFIGURATION_FILTER = "org.aspectj.weaver.loadtime.configuration.filter";
    public static final String CONFIGURATION_MAVEN_REPOSITORY = "repo.remote.url";
    public static final String MVEL_PREFIX = "mvel:";
    public static final String MVEL_PACKAGE_PREFIX = "org.mvel2";
    public static final String JAVAX_MANAGEMENT_REMOTE_RMI_PACKAGE = "javax.management.remote.rmi";

    public static Object checkMvelExpression(String source) {
        if (source.startsWith(MVEL_PREFIX)) {
            String expression = source.substring(MVEL_PREFIX.length());
            return MVEL.eval((String)expression);
        }
        return source;
    }

    public static Throwable unwrapMvelException(RuntimeException exception) {
        Throwable resultException;
        for (resultException = exception; resultException != null && resultException.getStackTrace() != null && resultException.getStackTrace().length > 0 && (resultException.getStackTrace()[0].getClassName().startsWith(MVEL_PACKAGE_PREFIX) || resultException.getClass().isAssignableFrom(InvocationTargetException.class)) && resultException.getCause() != null; resultException = resultException.getCause()) {
        }
        return resultException;
    }

    public static Object executeMvelExpression(Serializable compiledScript, VariableResolverFactory variableResolverFactory) throws Throwable {
        try {
            return MVEL.executeExpression((Object)compiledScript, (VariableResolverFactory)variableResolverFactory);
        }
        catch (RuntimeException exception) {
            throw Utils.unwrapMvelException(exception);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static Serializable compileMvelExpression(String expression) {
        return MVEL.compileExpression((String)expression);
    }

    public static boolean isSkippedClassLoader() {
        StackTraceElement[] stackTrace;
        boolean isMavenClassLoader = false;
        for (StackTraceElement traceElement : stackTrace = new Exception().getStackTrace()) {
            if (!MavenLoader.class.getName().equals(traceElement.getClassName()) && !traceElement.getClassName().startsWith(JAVAX_MANAGEMENT_REMOTE_RMI_PACKAGE)) continue;
            isMavenClassLoader = true;
            break;
        }
        return isMavenClassLoader;
    }

    public static void fillResolveParams(Map<String, Object> resultParams, VariableResolverFactory resolverFactory1) {
        if (resultParams != null && resultParams.size() > 0) {
            for (Map.Entry<String, Object> entry : resultParams.entrySet()) {
                resolverFactory1.createVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void executeExpression(Expression expression, VariableResolverFactory variableResolverFactory) {
        if (expression != null && expression.isNotEmpty()) {
            Utils.fillResolveParams(expression.getResultParams(), variableResolverFactory);
            MVEL.eval((String)expression.getExpression(), (VariableResolverFactory)variableResolverFactory);
        }
    }

    public static void registerDisposeExpression(final Expression expression, final VariableResolverFactory resolverFactory) {
        if (expression != null && expression.isNotEmpty()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Utils.executeExpression(expression, resolverFactory);
                }
            });
        }
    }
}

