/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.aspectj.configuration.AspectJDescriptor;
import org.aspectj.util.Utils;
import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWeavingContext
implements IWeavingContext {
    protected BcelWeakClassLoaderReference loaderRef;
    private String shortName;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(DefaultWeavingContext.class);
    private static final String AOP_FROM_CONFIGURATION_PREFIX = "config:";

    public DefaultWeavingContext(ClassLoader loader) {
        this.loaderRef = new BcelWeakClassLoaderReference(loader);
    }

    public Enumeration getResources(String name) throws IOException {
        if (name != null && !name.isEmpty()) {
            if (Utils.isSkippedClassLoader()) {
                return new Enumeration(){

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        throw new NoSuchElementException();
                    }
                };
            }
            String resource = Utils.checkMvelExpression(name).toString();
            URL url = null;
            if (resource.startsWith("http")) {
                url = new URL(resource);
            } else if (resource.startsWith(AOP_FROM_CONFIGURATION_PREFIX)) {
                String configuration = resource.substring(AOP_FROM_CONFIGURATION_PREFIX.length());
                String configurationLocation = Utils.checkMvelExpression(configuration).toString();
                url = AspectJDescriptor.renderConfigurationToTemporaryFile(configurationLocation);
            }
            if (url != null) {
                return Collections.enumeration(Arrays.asList(url));
            }
        }
        return this.getClassLoader().getResources(name);
    }

    public String getBundleIdFromURL(URL url) {
        return "";
    }

    public String getClassLoaderName() {
        ClassLoader loader = this.getClassLoader();
        return loader != null ? loader.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(loader)) : "null";
    }

    public ClassLoader getClassLoader() {
        return this.loaderRef.getClassLoader();
    }

    public String getFile(URL url) {
        return url.getFile();
    }

    public String getId() {
        if (this.shortName == null) {
            this.shortName = this.getClassLoaderName().replace('$', '.');
            int index = this.shortName.lastIndexOf(".");
            if (index != -1) {
                this.shortName = this.shortName.substring(index + 1);
            }
        }
        return this.shortName;
    }

    public String getSuffix() {
        return this.getClassLoaderName();
    }

    public boolean isLocallyDefined(String classname) {
        URL parentURL;
        String asResource = classname.replace('.', '/').concat(".class");
        ClassLoader loader = this.getClassLoader();
        URL localURL = loader.getResource(asResource);
        if (localURL == null) {
            return false;
        }
        boolean isLocallyDefined = true;
        ClassLoader parent = loader.getParent();
        if (parent != null && localURL.equals(parentURL = parent.getResource(asResource))) {
            isLocallyDefined = false;
        }
        return isLocallyDefined;
    }

    public List<Definition> getDefinitions(ClassLoader loader, WeavingAdaptor adaptor) {
        if (trace.isTraceEnabled()) {
            trace.enter("getDefinitions", (Object)this, new Object[]{"goo", adaptor});
        }
        List definitions = ((ClassLoaderWeavingAdaptor)adaptor).parseDefinitions(loader);
        if (trace.isTraceEnabled()) {
            trace.exit("getDefinitions", (Object)definitions);
        }
        return definitions;
    }
}

