/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.tuple.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class BigDecGen
implements Gen<BigDecimal> {
    private static final Gen<BigDecimal> arbitrary = new BigDecGen();

    private BigDecGen() {
    }

    public static Gen<BigDecimal> arbitrary() {
        return arbitrary;
    }

    public static Gen<BigDecimal> biased(BigDecimal min, BigDecimal max) {
        Objects.requireNonNull(min);
        Objects.requireNonNull(max);
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("max <= min");
        }
        ArrayList gens = new ArrayList();
        if (max.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 && min.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Long.MAX_VALUE))));
        }
        if (max.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) > 0 && min.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Long.MIN_VALUE))));
        }
        if (max.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0 && min.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Integer.MAX_VALUE))));
        }
        if (max.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) > 0 && min.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Integer.MIN_VALUE))));
        }
        if (max.compareTo(BigDecimal.valueOf(32767L)) > 0 && min.compareTo(BigDecimal.valueOf(32767L)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(32767L))));
        }
        if (max.compareTo(BigDecimal.valueOf(-32768L)) > 0 && min.compareTo(BigDecimal.valueOf(-32768L)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(-32768L))));
        }
        if (max.compareTo(BigDecimal.valueOf(127L)) > 0 && min.compareTo(BigDecimal.valueOf(127L)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(127L))));
        }
        if (max.compareTo(BigDecimal.valueOf(-128L)) > 0 && min.compareTo(BigDecimal.valueOf(-128L)) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(-128L))));
        }
        if (max.compareTo(BigDecimal.ZERO) > 0 && min.compareTo(BigDecimal.ZERO) < 0) {
            gens.add(Pair.of(1, Gen.cons(BigDecimal.ZERO)));
        }
        gens.add(Pair.of(1, Gen.cons(min)));
        if (!max.equals(min)) {
            gens.add(Pair.of(1, Gen.cons(max)));
        }
        gens.add(Pair.of(gens.size(), BigDecGen.arbitrary(min, max)));
        return Combinators.freqList(gens);
    }

    public static Gen<BigDecimal> arbitrary(BigDecimal min, BigDecimal max) {
        Objects.requireNonNull(min);
        Objects.requireNonNull(max);
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("max <= min");
        }
        return seed -> () -> {
            BigDecimal random = min.add(BigDecimal.valueOf(seed.nextDouble()).multiply(max.subtract(min)));
            return random.setScale(2, RoundingMode.HALF_UP);
        };
    }

    public static Gen<BigDecimal> biased() {
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Long.MAX_VALUE))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Long.MIN_VALUE))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Integer.MAX_VALUE))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(Integer.MIN_VALUE))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(32767L))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(-32768L))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(127L))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(-128L))));
        gens.add(Pair.of(1, Gen.cons(BigDecimal.valueOf(0L))));
        gens.add(Pair.of(gens.size(), arbitrary));
        return Combinators.freqList(gens);
    }

    @Override
    public Supplier<BigDecimal> apply(Random gen) {
        Objects.requireNonNull(gen);
        return () -> BigDecimal.valueOf(gen.nextDouble());
    }
}

