/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.tuple.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class BigIntGen
implements Gen<BigInteger> {
    private final int nBits;

    private BigIntGen(int nBits) {
        if (nBits < 0) {
            throw new IllegalArgumentException("nBits < 0");
        }
        this.nBits = nBits;
    }

    public static Gen<BigInteger> arbitrary(int bits) {
        return new BigIntGen(bits);
    }

    public static Gen<BigInteger> biased(int bits) {
        BigInteger max = BigInteger.valueOf(2L).pow(bits);
        ArrayList gens = new ArrayList();
        if (max.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            gens.add(Pair.of(1, Gen.cons(BigInteger.valueOf(Long.MAX_VALUE))));
        }
        if (max.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            gens.add(Pair.of(1, Gen.cons(BigInteger.valueOf(Integer.MAX_VALUE))));
        }
        if (max.compareTo(BigInteger.valueOf(32767L)) > 0) {
            gens.add(Pair.of(1, Gen.cons(BigInteger.valueOf(32767L))));
        }
        if (max.compareTo(BigInteger.valueOf(127L)) > 0) {
            gens.add(Pair.of(1, Gen.cons(BigInteger.valueOf(127L))));
        }
        gens.add(Pair.of(1, Gen.cons(BigInteger.ZERO)));
        gens.add(Pair.of(1, Gen.cons(max)));
        gens.add(Pair.of(gens.size(), BigIntGen.arbitrary(bits)));
        return Combinators.freqList(gens);
    }

    @Override
    public Supplier<BigInteger> apply(final Random gen) {
        Objects.requireNonNull(gen);
        Random rnd = new Random(){

            @Override
            protected int next(int bits) {
                return gen.nextInt(bits);
            }
        };
        return () -> new BigInteger(this.nBits, rnd);
    }
}

