/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.gen.IntGen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class BytesGen
implements Gen<byte[]> {
    private final int length;

    private BytesGen(int length) {
        this.length = length;
    }

    public static Gen<byte[]> arbitrary(int minLength, int maxLength) {
        if (maxLength < minLength) {
            throw new IllegalArgumentException("max < min");
        }
        return seed -> BytesGen.genBytes(seed, (Supplier)IntGen.arbitrary(minLength, maxLength).apply(seed));
    }

    public static Gen<byte[]> biased(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("min < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("max < min");
        }
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, new BytesGen(minLength)));
        if (maxLength != minLength) {
            gens.add(Pair.of(1, new BytesGen(maxLength)));
        }
        gens.add(Pair.of(gens.size(), BytesGen.arbitrary(minLength, maxLength)));
        return Combinators.freqList(gens);
    }

    private static Supplier<byte[]> genBytes(Random gen, Supplier<Integer> size) {
        return () -> {
            byte[] bytes = new byte[((Integer)size.get()).intValue()];
            gen.nextBytes(bytes);
            return bytes;
        };
    }

    @Override
    public Supplier<byte[]> apply(Random gen) {
        Objects.requireNonNull(gen);
        return BytesGen.genBytes(gen, () -> this.length);
    }
}

