/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.gen.IntGen;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class CharGen
implements Gen<Character> {
    private static final Gen<Character> ascii = IntGen.arbitrary(0, 127).map(it -> Character.valueOf((char)it.intValue()));
    private static final Gen<Character> letter = IntGen.arbitrary(0, 25).map(i -> Character.valueOf((char)(97 + i)));
    private static final Gen<Character> digit = Combinators.oneOf(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
    private static final Gen<Character> alphabetic = Combinators.oneOf(IntGen.arbitrary(65, 90), IntGen.arbitrary(97, 122)).map(i -> Character.valueOf((char)i.intValue()));
    private static final Gen<Character> arbitrary = new CharGen();

    private CharGen() {
    }

    public static Gen<Character> ascii() {
        return ascii;
    }

    public static Gen<Character> letter() {
        return letter;
    }

    public static Gen<Character> digit() {
        return digit;
    }

    public static Gen<Character> alphabetic() {
        return alphabetic;
    }

    static boolean isNonCharacter(int codepoint) {
        if (codepoint >= 55296 && codepoint <= 57343) {
            return true;
        }
        if (codepoint >= 64976 && codepoint <= 65007) {
            return true;
        }
        return codepoint == 65534 || codepoint == 65535;
    }

    static boolean isPUC(int codepoint) {
        return codepoint >= 57344 && codepoint <= 63743;
    }

    public static Gen<Character> arbitrary(char min, char max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        return seed -> CharGen.supplier(seed, min, max);
    }

    public static Gen<Character> arbitrary() {
        return arbitrary;
    }

    static Supplier<Character> supplier(Random gen, char min, char max) {
        Supplier supplier = (Supplier)IntGen.arbitrary(min, max).suchThat(it -> !CharGen.isNonCharacter(it) && !CharGen.isPUC(it)).apply(gen);
        return () -> CharGen.lambda$supplier$5((Supplier)supplier);
    }

    @Override
    public Supplier<Character> apply(Random seed) {
        Objects.requireNonNull(seed);
        return CharGen.supplier(seed, '\u0000', '\uffff');
    }

    private static /* synthetic */ Character lambda$supplier$5(Supplier supplier) {
        return Character.valueOf((char)((Integer)supplier.get()).intValue());
    }
}

