/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Gen;
import fun.gen.IntGen;
import fun.gen.SplitGen;
import fun.gen.SubsetGen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Combinators {
    private Combinators() {
    }

    @SafeVarargs
    public static <T> Gen<T> oneOf(T value, T ... others) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(others);
        return r -> () -> {
            int n = r.nextInt(others.length + 1);
            return n == 0 ? value : others[n - 1];
        };
    }

    public static <T> Gen<T> oneOf(List<T> values) {
        if (Objects.requireNonNull(values).isEmpty()) {
            throw new RuntimeException("list empty. No value can be generated");
        }
        return r -> () -> values.get(Objects.requireNonNull(r).nextInt(values.size()));
    }

    public static <T> Gen<T> oneOf(Set<T> values) {
        if (Objects.requireNonNull(values).isEmpty()) {
            throw new RuntimeException("set empty. No value can be generated");
        }
        return r -> {
            int size = values.size();
            return () -> {
                int counter = 0;
                Iterator iterator = values.iterator();
                int j = r.nextInt(size);
                Object value = null;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (j == counter) {
                        value = next;
                    }
                    ++counter;
                }
                return value;
            };
        };
    }

    public static <T> Gen<List<T>> nOf(List<T> values, int n) {
        if (n > values.size()) {
            throw new IllegalArgumentException("n > list.size=" + values.size());
        }
        return random -> () -> {
            ArrayList result = new ArrayList();
            ArrayList copy = new ArrayList(values);
            Combinators.generateCollection(n, random, result, copy);
            return result;
        };
    }

    public static <T> Gen<Set<T>> nOf(Set<T> values, int n) {
        if (n > values.size()) {
            throw new IllegalArgumentException("n > set.size=" + values.size());
        }
        return random -> () -> {
            HashSet result = new HashSet();
            HashSet copy = new HashSet(values);
            Combinators.generateCollection(n, random, result, copy);
            return result;
        };
    }

    private static <T> void generateCollection(int n, Random random, Collection<T> result, Collection<T> copy) {
        for (int i = 0; i < n; ++i) {
            int counter = 0;
            int j = random.nextInt(copy.size());
            Iterator<T> iter = copy.iterator();
            while (iter.hasNext()) {
                T next = iter.next();
                if (j == counter) {
                    result.add(next);
                    iter.remove();
                }
                ++counter;
            }
        }
    }

    @SafeVarargs
    public static <A> Gen<A> oneOf(Gen<? extends A> gen, Gen<? extends A> ... others) {
        Objects.requireNonNull(gen);
        Objects.requireNonNull(others);
        return r -> {
            ArrayList<Supplier> suppliers = new ArrayList<Supplier>();
            suppliers.add(Objects.requireNonNull((Supplier)gen.apply((Random)SplitGen.DEFAULT.apply(r))));
            suppliers.addAll(Arrays.stream(others).map(it -> (Supplier)it.apply((Random)SplitGen.DEFAULT.apply(r))).collect(Collectors.toList()));
            int bound = 1 + Objects.requireNonNull(others).length;
            return () -> ((Supplier)suppliers.get(r.nextInt(bound))).get();
        };
    }

    @SafeVarargs
    public static <A> Gen<A> freq(Pair<Integer, Gen<? extends A>> freq, Pair<Integer, Gen<? extends A>> ... others) {
        List<Pair<Integer, Gen<A>>> list = Arrays.stream(Objects.requireNonNull(others)).collect(Collectors.toList());
        list.add(Objects.requireNonNull(freq));
        return Combinators.freqList(list);
    }

    static <A> Gen<A> freqList(List<Pair<Integer, Gen<? extends A>>> freqs) {
        return seed -> {
            List filtered = Objects.requireNonNull(freqs).stream().filter(it -> (Integer)it.first() > 0).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                throw new IllegalArgumentException("no items with positive weights");
            }
            return Combinators.freqSupplier(SplitGen.DEFAULT, seed, filtered);
        };
    }

    private static <A> Supplier<A> freqSupplier(SplitGen split, Random seed, List<Pair<Integer, Gen<? extends A>>> filtered) {
        int total = 0;
        TreeMap<Integer, Supplier> treeMap = new TreeMap<Integer, Supplier>();
        for (Pair<Integer, Gen<A>> t : filtered) {
            treeMap.put(total += t.first().intValue(), (Supplier)t.second().apply((Random)split.apply(seed)));
        }
        Supplier choose = (Supplier)IntGen.arbitrary(1, total).apply((Random)split.apply(seed));
        return () -> Combinators.lambda$freqSupplier$15(treeMap, (Supplier)choose);
    }

    public static <O> Gen<O> nullable(Gen<O> gen) {
        return Combinators.nullable(gen, 50);
    }

    public static <O> Gen<O> nullable(Gen<O> gen, int prob) {
        Objects.requireNonNull(gen);
        if (prob < 0) {
            throw new IllegalArgumentException("prob < 0");
        }
        if (prob > 100) {
            throw new IllegalArgumentException("prob > 100");
        }
        return seed -> {
            Supplier n = (Supplier)IntGen.arbitrary(0, 100).apply((Random)SplitGen.DEFAULT.apply(seed));
            Supplier supplier = (Supplier)gen.apply((Random)SplitGen.DEFAULT.apply(seed));
            return () -> Combinators.lambda$nullable$16((Supplier)n, prob, (Supplier)supplier);
        };
    }

    public static <I> Gen<Set<I>> combinations(int k, List<I> input) {
        return Combinators.subsets(input).suchThat(it -> it.size() == k);
    }

    public static <I> Gen<Set<I>> combinations(int k, Set<I> input) {
        return Combinators.combinations(k, new ArrayList<I>(input));
    }

    public static <I> Gen<Set<I>> subsets(List<I> elements) {
        return new SubsetGen<I>(elements);
    }

    public static <I> Gen<Set<I>> subsets(Set<I> elements) {
        return Combinators.subsets(new ArrayList<I>(elements));
    }

    public static <I> Gen<List<I>> shuffle(List<I> xs) {
        return random -> () -> {
            ArrayList ys = new ArrayList(xs);
            Collections.shuffle(ys, random);
            return ys;
        };
    }

    private static /* synthetic */ Object lambda$nullable$16(Supplier n, int prob, Supplier supplier) {
        return (Integer)n.get() <= prob ? null : supplier.get();
    }

    private static /* synthetic */ Object lambda$freqSupplier$15(TreeMap treeMap, Supplier choose) {
        return ((Supplier)treeMap.ceilingEntry((Integer)choose.get()).getValue()).get();
    }
}

