/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class DoubleGen
implements Gen<Double> {
    private static final Gen<Double> arbitrary = new DoubleGen();

    private DoubleGen() {
    }

    public static Gen<Double> arbitrary() {
        return arbitrary;
    }

    public static Gen<Double> biased(double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        ArrayList gens = new ArrayList();
        if (max > 2.147483647E9 && min < 2.147483647E9) {
            gens.add(Pair.of(1, Gen.cons(2.147483647E9)));
        }
        if (max > -2.147483648E9 && min < -2.147483648E9) {
            gens.add(Pair.of(1, Gen.cons(-2.147483648E9)));
        }
        if (max > 32767.0 && min < 32767.0) {
            gens.add(Pair.of(1, Gen.cons(32767.0)));
        }
        if (max > -32768.0 && min < -32768.0) {
            gens.add(Pair.of(1, Gen.cons(-32768.0)));
        }
        if (max > 127.0 && min < 127.0) {
            gens.add(Pair.of(1, Gen.cons(127.0)));
        }
        if (max > -128.0 && min < -128.0) {
            gens.add(Pair.of(1, Gen.cons(-128.0)));
        }
        if (max > 0.0 && min < 0.0) {
            gens.add(Pair.of(1, Gen.cons(0.0)));
        }
        gens.add(Pair.of(1, Gen.cons(min)));
        if (max != min) {
            gens.add(Pair.of(1, Gen.cons(max)));
        }
        gens.add(Pair.of(gens.size(), DoubleGen.arbitrary(min, max)));
        return Combinators.freqList(gens);
    }

    public static Gen<Double> arbitrary(double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        return seed -> () -> {
            double r = seed.nextDouble();
            if ((r = r * (max - min) + min) > max) {
                r = Double.longBitsToDouble(Double.doubleToLongBits(max) - 1L);
            }
            return r;
        };
    }

    public static Gen<Double> biased() {
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, Gen.cons(Double.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Double.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(9.223372036854776E18)));
        gens.add(Pair.of(1, Gen.cons(-9.223372036854776E18)));
        gens.add(Pair.of(1, Gen.cons(2.147483647E9)));
        gens.add(Pair.of(1, Gen.cons(-2.147483648E9)));
        gens.add(Pair.of(1, Gen.cons(32767.0)));
        gens.add(Pair.of(1, Gen.cons(-32768.0)));
        gens.add(Pair.of(1, Gen.cons(127.0)));
        gens.add(Pair.of(1, Gen.cons(-128.0)));
        gens.add(Pair.of(1, Gen.cons(0.0)));
        gens.add(Pair.of(gens.size(), arbitrary));
        return Combinators.freqList(gens);
    }

    @Override
    public Supplier<Double> apply(Random gen) {
        Objects.requireNonNull(gen);
        return gen::nextDouble;
    }
}

