/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.SplitGen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FunctionalInterface
public interface Gen<O>
extends Function<Random, Supplier<O>> {
    public static <O> Gen<O> cons(O value) {
        return seed -> () -> value;
    }

    default public Gen<O> distinct() {
        return this.distinct(1000);
    }

    default public Gen<O> distinct(int tries) {
        return seed -> {
            HashSet generated = new HashSet();
            Supplier gen = (Supplier)this.apply(seed);
            return () -> Gen.lambda$distinct$2(tries, (Supplier)gen, generated);
        };
    }

    default public <P> Gen<P> map(Function<O, P> fn) {
        Objects.requireNonNull(fn);
        return seed -> {
            Supplier gen = (Supplier)this.apply(seed);
            return () -> Gen.lambda$map$4(fn, (Supplier)gen);
        };
    }

    default public Gen<O> peek(Consumer<O> consumer) {
        return this.map(it -> {
            consumer.accept(it);
            return it;
        });
    }

    default public <P> Gen<P> then(Function<O, ? extends Gen<P>> fn) {
        Objects.requireNonNull(fn);
        return seed -> (Supplier)((Gen)fn.apply(((Supplier)this.apply((Random)SplitGen.DEFAULT.apply(seed))).get())).apply((Random)SplitGen.DEFAULT.apply(seed));
    }

    default public Gen<O> suchThat(Predicate<O> predicate) {
        return this.suchThat(Objects.requireNonNull(predicate), 1000);
    }

    default public Gen<O> suchThat(Predicate<O> predicate, int tries) {
        Objects.requireNonNull(predicate);
        if (tries < 0) {
            throw new IllegalArgumentException("tries < 0");
        }
        return r -> {
            Supplier supplier = (Supplier)this.apply(r);
            return () -> Gen.lambda$suchThat$8(r, tries, (Supplier)supplier, predicate);
        };
    }

    default public Supplier<O> sample() {
        return (Supplier)this.apply(new Random());
    }

    default public Stream<O> sample(int n) {
        return Stream.generate((Supplier)this.apply(new Random())).limit(n);
    }

    default public Supplier<O> sample(Random random) {
        return (Supplier)this.apply(Objects.requireNonNull(random));
    }

    default public Map<O, Long> collect(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return this.sample(n).collect(Collectors.groupingBy(value -> value, Collectors.counting()));
    }

    default public <I> Map<I, Long> collect(int n, Function<O, I> map) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return this.map(Objects.requireNonNull(map)).collect(n);
    }

    default public Map<String, Long> classify(Predicate<O> condition, String trueLabel, String falseLabel, int n) {
        return this.map(val -> condition.test(val) ? trueLabel : falseLabel).collect(n);
    }

    default public Map<String, Long> classify(int n, Map<String, Predicate<O>> classifier) {
        Predicate<Object> defaultClassifier = o -> classifier.values().stream().noneMatch(cla -> cla.test(o));
        HashMap xs = new HashMap(classifier);
        xs.put("Others", defaultClassifier);
        return this.collect(n, o -> xs.keySet().stream().filter(key -> ((Predicate)xs.get(key)).test(o)).collect(Collectors.joining(",")));
    }

    private static /* synthetic */ Object lambda$suchThat$8(Random r, int tries, Supplier supplier, Predicate predicate) {
        Objects.requireNonNull(r);
        for (int i = 0; i < tries; ++i) {
            Object value = supplier.get();
            if (!predicate.test(value)) continue;
            return value;
        }
        throw new RuntimeException(String.format("Couldn't satisfy such-that predicate after %s tries", tries));
    }

    private static /* synthetic */ Object lambda$map$4(Function fn, Supplier gen) {
        return fn.apply(gen.get());
    }

    private static /* synthetic */ Object lambda$distinct$2(int tries, Supplier gen, Set generated) {
        for (int i = 0; i < tries; ++i) {
            Object value = gen.get();
            if (generated.contains(value)) continue;
            generated.add(value);
            return value;
        }
        throw new RuntimeException("Max tries reached trying to generate a distinct value");
    }
}

