/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.gen.LongGen;
import fun.tuple.Pair;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class InstantGen
implements Gen<Instant> {
    private static final Gen<Instant> arbitrary = new InstantGen();
    private static final long MAX_SECONDS = Instant.MAX.getEpochSecond();
    private static final long MIN_SECONDS = Instant.MIN.getEpochSecond();

    private InstantGen() {
    }

    public static Gen<Instant> arbitrary() {
        return arbitrary;
    }

    public static Gen<Instant> biased() {
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, Gen.cons(MAX_SECONDS)));
        gens.add(Pair.of(1, Gen.cons(MIN_SECONDS)));
        gens.add(Pair.of(1, Gen.cons(Integer.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Integer.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(0L)));
        gens.add(Pair.of(gens.size(), LongGen.arbitrary(MIN_SECONDS, MAX_SECONDS)));
        return Combinators.freqList(gens).map(Instant::ofEpochSecond);
    }

    public static Gen<Instant> biased(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException(max + " is greater than " + min);
        }
        if (max > MAX_SECONDS) {
            throw new IllegalArgumentException(max + " is greater than MAX_SECONDS " + MAX_SECONDS);
        }
        if (min < MIN_SECONDS) {
            throw new IllegalArgumentException(max + " is lower than MIN_SECONDS " + MIN_SECONDS);
        }
        ArrayList gens = new ArrayList();
        if (min <= Integer.MAX_VALUE && max >= Integer.MAX_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Integer.MAX_VALUE)));
        }
        if (min <= Integer.MIN_VALUE && max >= Integer.MIN_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Integer.MIN_VALUE)));
        }
        if (min <= 0L && max >= 0L) {
            gens.add(Pair.of(1, Gen.cons(0L)));
        }
        gens.add(Pair.of(1, Gen.cons(min)));
        if (max != min) {
            gens.add(Pair.of(1, Gen.cons(max)));
        }
        gens.add(Pair.of(gens.size(), LongGen.arbitrary(min, max)));
        return Combinators.freqList(gens).map(Instant::ofEpochSecond);
    }

    public static Gen<Instant> arbitrary(ZonedDateTime min, ZonedDateTime max) {
        if (Objects.requireNonNull(max).isBefore(Objects.requireNonNull(min))) {
            throw new IllegalArgumentException(min.format(DateTimeFormatter.ISO_INSTANT) + " is greater than " + max.format(DateTimeFormatter.ISO_INSTANT));
        }
        return InstantGen.arbitrary(min.toEpochSecond(), max.toEpochSecond());
    }

    public static Gen<Instant> biased(ZonedDateTime min, ZonedDateTime max) {
        if (Objects.requireNonNull(max).isBefore(Objects.requireNonNull(min))) {
            throw new IllegalArgumentException(min.format(DateTimeFormatter.ISO_INSTANT) + " is greater than " + max.format(DateTimeFormatter.ISO_INSTANT));
        }
        return InstantGen.biased(min.toEpochSecond(), max.toEpochSecond());
    }

    public static Gen<Instant> arbitrary(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException(max + " is greater than " + min);
        }
        if (max > MAX_SECONDS) {
            throw new IllegalArgumentException(max + " is greater than MAX_SECONDS " + MAX_SECONDS);
        }
        if (min < MIN_SECONDS) {
            throw new IllegalArgumentException(max + " is lower than MIN_SECONDS " + MIN_SECONDS);
        }
        return LongGen.arbitrary(min, max).map(Instant::ofEpochSecond);
    }

    @Override
    public Supplier<Instant> apply(Random gen) {
        Objects.requireNonNull(gen);
        return (Supplier)LongGen.arbitrary(MIN_SECONDS, MAX_SECONDS).map(Instant::ofEpochSecond).apply(gen);
    }
}

