/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class IntGen
implements Gen<Integer> {
    private static final Gen<Integer> arbitrary = new IntGen();

    private IntGen() {
    }

    public static Gen<Integer> arbitrary() {
        return arbitrary;
    }

    public static Gen<Integer> biased(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        ArrayList gens = new ArrayList();
        if (max > Short.MAX_VALUE && min < Short.MAX_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Short.MAX_VALUE)));
        }
        if (max > Short.MIN_VALUE && min < Short.MIN_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Short.MIN_VALUE)));
        }
        if (max > 127 && min < 127) {
            gens.add(Pair.of(1, Gen.cons(127)));
        }
        if (max > -128 && min < -128) {
            gens.add(Pair.of(1, Gen.cons(-128)));
        }
        if (max > 0 && min < 0) {
            gens.add(Pair.of(1, Gen.cons(0)));
        }
        gens.add(Pair.of(1, Gen.cons(min)));
        if (max != min) {
            gens.add(Pair.of(1, Gen.cons(max)));
        }
        gens.add(Pair.of(gens.size(), IntGen.arbitrary(min, max)));
        return Combinators.freqList(gens);
    }

    public static Gen<Integer> arbitrary(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        return seed -> () -> {
            int r = seed.nextInt();
            int n = max - min + 1;
            int m = n - 1;
            if ((n & m) == 0) {
                r = (r & m) + min;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m - (r = u % n) < 0) {
                    u = seed.nextInt() >>> 1;
                }
                r += min;
            } else {
                while (r < min || r > max) {
                    r = seed.nextInt();
                }
            }
            return r;
        };
    }

    public static Gen<Integer> biased() {
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, Gen.cons(Integer.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Integer.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Short.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Short.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(127)));
        gens.add(Pair.of(1, Gen.cons(-128)));
        gens.add(Pair.of(1, Gen.cons(0)));
        gens.add(Pair.of(gens.size(), arbitrary));
        return Combinators.freqList(gens);
    }

    @Override
    public Supplier<Integer> apply(Random gen) {
        Objects.requireNonNull(gen);
        return Objects.requireNonNull(gen)::nextInt;
    }
}

