/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.gen.IntGen;
import fun.gen.SplitGen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ListGen<T>
implements Gen<List<T>> {
    private final Gen<T> gen;
    private final int size;

    private ListGen(Gen<T> gen, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.gen = Objects.requireNonNull(gen);
        this.size = size;
    }

    public static <T> ListGen<T> ofN(Gen<T> gen, int size) {
        return new ListGen<T>(gen, size);
    }

    public static <T> Gen<List<T>> biased(Gen<T> gen, int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        Objects.requireNonNull(gen);
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, new ListGen<T>(gen, minLength)));
        gens.add(Pair.of(1, new ListGen<T>(gen, maxLength)));
        gens.add(Pair.of(gens.size(), ListGen.arbitrary(gen, minLength, maxLength)));
        return Combinators.freqList(gens);
    }

    public static <T> Gen<List<T>> arbitrary(Gen<T> gen, int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        Objects.requireNonNull(gen);
        return seed -> {
            Supplier sizeSupplier = (Supplier)IntGen.arbitrary(minLength, maxLength).apply((Random)SplitGen.DEFAULT.apply(seed));
            Supplier elemSupplier = (Supplier)gen.apply((Random)SplitGen.DEFAULT.apply(seed));
            return ListGen.listSupplier(sizeSupplier, elemSupplier);
        };
    }

    private static <T> Supplier<List<T>> listSupplier(Supplier<Integer> sizeSupplier, Supplier<T> elemSupplier) {
        return () -> IntStream.range(0, (Integer)sizeSupplier.get()).mapToObj(arg_0 -> ListGen.lambda$listSupplier$1((Supplier)elemSupplier, arg_0)).collect(Collectors.toList());
    }

    @Override
    public Supplier<List<T>> apply(Random seed) {
        Objects.requireNonNull(seed);
        return ListGen.listSupplier(() -> this.size, (Supplier)this.gen.apply(Objects.requireNonNull(seed)));
    }

    private static /* synthetic */ Object lambda$listSupplier$1(Supplier elemSupplier, int i) {
        return elemSupplier.get();
    }
}

