/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Combinators;
import fun.gen.Gen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class LongGen
implements Gen<Long> {
    private static final Gen<Long> arbitrary = new LongGen();

    private LongGen() {
    }

    public static Gen<Long> arbitrary() {
        return arbitrary;
    }

    public static Gen<Long> biased(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        ArrayList gens = new ArrayList();
        if (max > Integer.MAX_VALUE && min < Integer.MAX_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Integer.MAX_VALUE)));
        }
        if (max > Integer.MIN_VALUE && min < Integer.MIN_VALUE) {
            gens.add(Pair.of(1, Gen.cons(Integer.MIN_VALUE)));
        }
        if (max > 32767L && min < 32767L) {
            gens.add(Pair.of(1, Gen.cons(32767L)));
        }
        if (max > -32768L && min < -32768L) {
            gens.add(Pair.of(1, Gen.cons(-32768L)));
        }
        if (max > 127L && min < 127L) {
            gens.add(Pair.of(1, Gen.cons(127L)));
        }
        if (max > -128L && min < -128L) {
            gens.add(Pair.of(1, Gen.cons(-128L)));
        }
        if (max > 0L && min < 0L) {
            gens.add(Pair.of(1, Gen.cons(0L)));
        }
        gens.add(Pair.of(1, Gen.cons(min)));
        if (max != min) {
            gens.add(Pair.of(1, Gen.cons(max)));
        }
        gens.add(Pair.of(gens.size(), LongGen.arbitrary(min, max)));
        return Combinators.freqList(gens);
    }

    public static Gen<Long> arbitrary(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        return seed -> () -> {
            long r = seed.nextLong();
            long n = max - min + 1L;
            long m = n - 1L;
            if ((n & m) == 0L) {
                r = (r & m) + min;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m - (r = u % n) < 0L) {
                    u = seed.nextLong() >>> 1;
                }
                r += min;
            } else {
                while (r < min || r > max) {
                    r = seed.nextLong();
                }
            }
            return r;
        };
    }

    public static Gen<Long> biased() {
        ArrayList gens = new ArrayList();
        gens.add(Pair.of(1, Gen.cons(Long.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Long.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Integer.MAX_VALUE)));
        gens.add(Pair.of(1, Gen.cons(Integer.MIN_VALUE)));
        gens.add(Pair.of(1, Gen.cons(32767L)));
        gens.add(Pair.of(1, Gen.cons(-32768L)));
        gens.add(Pair.of(1, Gen.cons(127L)));
        gens.add(Pair.of(1, Gen.cons(-128L)));
        gens.add(Pair.of(1, Gen.cons(0L)));
        gens.add(Pair.of(gens.size(), arbitrary));
        return Combinators.freqList(gens);
    }

    @Override
    public Supplier<Long> apply(Random gen) {
        Objects.requireNonNull(gen);
        return gen::nextLong;
    }
}

