/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Gen;
import fun.gen.SplitGen;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;

public final class MapGen<K, V>
implements Gen<Map<K, V>> {
    private final Gen<K> keyGen;
    private final Gen<V> valueGen;
    private final int size;
    private final int maxTries;
    private final SplitGen splitGen;

    private MapGen(Gen<K> keyGen, Gen<V> valueGen, int size, int maxTries) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (maxTries < size) {
            throw new IllegalArgumentException("maxTries < size");
        }
        this.keyGen = Objects.requireNonNull(keyGen);
        this.valueGen = Objects.requireNonNull(valueGen);
        this.size = size;
        this.maxTries = maxTries;
        this.splitGen = SplitGen.DEFAULT;
    }

    public static <K, V> MapGen<K, V> of(Gen<K> keyGen, Gen<V> valueGen, int size) {
        return new MapGen<K, V>(keyGen, valueGen, size, size * 100);
    }

    public MapGen<K, V> withMaxTries(int tries) {
        return new MapGen<K, V>(this.keyGen, this.valueGen, this.size, tries);
    }

    @Override
    public Supplier<Map<K, V>> apply(Random gen) {
        Objects.requireNonNull(gen);
        Supplier keys = (Supplier)this.keyGen.apply((Random)this.splitGen.apply(Objects.requireNonNull(gen)));
        Supplier values = (Supplier)this.valueGen.apply((Random)this.splitGen.apply(gen));
        return () -> this.lambda$apply$0((Supplier)keys, (Supplier)values);
    }

    private /* synthetic */ Map lambda$apply$0(Supplier keys, Supplier values) {
        HashMap map = new HashMap();
        int tries = 0;
        do {
            map.put(keys.get(), values.get());
        } while (++tries != this.maxTries && map.size() < this.size);
        if (map.size() < this.size) {
            throw new RuntimeException(String.format("Couldn't generate map of %s elements after %s tries", this.size, this.maxTries));
        }
        return map;
    }
}

