/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.RecordTypeNotExpected;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class Record {
    public final Map<String, ?> map;

    public Record(Map<String, ?> map) {
        this.map = Objects.requireNonNull(map);
    }

    public Optional<byte[]> getBytes(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof byte[]) {
            return Optional.of((byte[])value);
        }
        throw new RecordTypeNotExpected("byte[]", value.getClass(), key);
    }

    public Optional<Long> getLong(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Long) {
            return Optional.of((Long)value);
        }
        throw new RecordTypeNotExpected("Long", value.getClass(), key);
    }

    public Optional<String> getStr(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        throw new RecordTypeNotExpected("String", value.getClass(), key);
    }

    public Optional<Integer> getInt(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Integer) {
            return Optional.of((Integer)value);
        }
        throw new RecordTypeNotExpected("Integer", value.getClass(), key);
    }

    public Optional<BigDecimal> getDecimal(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof BigDecimal) {
            return Optional.of((BigDecimal)value);
        }
        throw new RecordTypeNotExpected("BigDecimal", value.getClass(), key);
    }

    public <O> Optional<List<O>> getList(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            return Optional.of((List)value);
        }
        throw new RecordTypeNotExpected("List", value.getClass(), key);
    }

    public <O> Optional<Set<O>> getSet(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Set) {
            return Optional.of((Set)value);
        }
        throw new RecordTypeNotExpected("Set", value.getClass(), key);
    }

    public <K, V> Optional<Map<K, V>> getMap(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Map) {
            return Optional.of((Map)value);
        }
        throw new RecordTypeNotExpected("Map", value.getClass(), key);
    }

    public Optional<Instant> getInstant(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Instant) {
            return Optional.of((Instant)value);
        }
        throw new RecordTypeNotExpected("Instant", value.getClass(), key);
    }

    public Optional<Double> getDouble(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Double) {
            return Optional.of((Double)value);
        }
        throw new RecordTypeNotExpected("Double", value.getClass(), key);
    }

    public Optional<Boolean> getBool(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Boolean) {
            return Optional.of((Boolean)value);
        }
        throw new RecordTypeNotExpected("Boolean", value.getClass(), key);
    }

    public Optional<Character> getChar(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Character) {
            return Optional.of((Character)value);
        }
        throw new RecordTypeNotExpected("Character", value.getClass(), key);
    }

    public Optional<BigInteger> getBigInt(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof BigInteger) {
            return Optional.of((BigInteger)value);
        }
        throw new RecordTypeNotExpected("BigInteger", value.getClass(), key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return Objects.equals(this.map, record.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        return this.map.toString();
    }
}

