/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.Gen;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;

public final class SetGen<T>
implements Gen<Set<T>> {
    private final Gen<T> gen;
    private final int size;
    private final int maxTries;

    private SetGen(Gen<T> gen, int size, int maxTries) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (maxTries < size) {
            throw new IllegalArgumentException("maxTries < size");
        }
        this.gen = Objects.requireNonNull(gen);
        this.size = size;
        this.maxTries = maxTries;
    }

    public static <T> SetGen<T> ofN(Gen<T> gen, int size) {
        return new SetGen<T>(gen, size, size * 10);
    }

    public SetGen<T> withMaxTries(int tries) {
        return new SetGen<T>(this.gen, this.size, tries);
    }

    @Override
    public Supplier<Set<T>> apply(Random seed) {
        Objects.requireNonNull(seed);
        if (this.size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.maxTries < 0) {
            throw new IllegalArgumentException("maxTries negative");
        }
        Supplier supplier = (Supplier)this.gen.apply(seed);
        return () -> this.lambda$apply$0((Supplier)supplier);
    }

    private /* synthetic */ Set lambda$apply$0(Supplier supplier) {
        int tries = 0;
        HashSet set = new HashSet();
        while (set.size() != this.size) {
            set.add(supplier.get());
            if (++tries < this.maxTries) continue;
            throw new RuntimeException(String.format("Couldn't generate set of %s different elements after %s tries", this.size, this.maxTries));
        }
        return set;
    }
}

