/*
 * Decompiled with CFR 0.152.
 */
package fun.gen;

import fun.gen.CharGen;
import fun.gen.Combinators;
import fun.gen.Gen;
import fun.gen.IntGen;
import fun.gen.ListGen;
import fun.gen.SplitGen;
import fun.tuple.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class StrGen
implements Gen<String> {
    private static final Gen<String> ascii = CharGen.ascii().map(String::valueOf);
    private static final Gen<String> digit = CharGen.digit().map(String::valueOf);
    private static final Gen<String> letter = CharGen.letter().map(String::valueOf);
    private static final Gen<String> alphabetic = CharGen.alphabetic().map(String::valueOf);
    private static final Gen<String> alphanumeric = Combinators.oneOf(CharGen.alphabetic(), CharGen.digit()).map(String::valueOf);
    private final int length;

    private StrGen(int length) {
        this.length = length;
    }

    public static Gen<String> biased(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        ArrayList gens = new ArrayList();
        if (minLength == maxLength && minLength == 0) {
            return Gen.cons("");
        }
        if (minLength == 0) {
            gens.add(Pair.of(1, Gen.cons("")));
        } else {
            gens.add(Pair.of(1, new StrGen(minLength)));
            gens.add(Pair.of(1, Gen.cons(StrGen.blank(minLength))));
        }
        if (minLength != maxLength) {
            gens.add(Pair.of(1, Gen.cons(StrGen.blank(maxLength))));
            gens.add(Pair.of(1, new StrGen(maxLength)));
        }
        gens.add(Pair.of(gens.size(), StrGen.arbitrary(minLength, maxLength)));
        return Combinators.freqList(gens);
    }

    public static Gen<String> arbitrary(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return seed -> StrGen.genStr((Random)SplitGen.DEFAULT.apply(seed), (Supplier)IntGen.arbitrary(minLength, maxLength).apply((Random)SplitGen.DEFAULT.apply(seed)));
    }

    private static Supplier<String> genStr(Random seed, Supplier<Integer> lengthGen) {
        return () -> {
            int l = (Integer)lengthGen.get();
            List arbitrary = (List)((Supplier)ListGen.arbitrary(CharGen.arbitrary(), l, l).apply(seed)).get();
            return StrGen.chars2String(arbitrary);
        };
    }

    private static Supplier<String> genStr(Random seed, Integer length) {
        Supplier chars = (Supplier)ListGen.arbitrary(CharGen.arbitrary(), length, length).apply(seed);
        return () -> StrGen.lambda$genStr$2((Supplier)chars);
    }

    private static String chars2String(List<Character> arbitrary) {
        return arbitrary.stream().map(Object::toString).collect(Collectors.joining());
    }

    public static Gen<String> digits(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return ListGen.arbitrary(digit, minLength, maxLength).map(it -> String.join((CharSequence)"", it));
    }

    public static Gen<String> ascii(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return ListGen.arbitrary(ascii, minLength, maxLength).map(it -> String.join((CharSequence)"", it));
    }

    public static Gen<String> letters(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return ListGen.arbitrary(letter, minLength, maxLength).map(it -> String.join((CharSequence)"", it));
    }

    public static Gen<String> alphabetic(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return ListGen.arbitrary(alphabetic, minLength, maxLength).map(it -> String.join((CharSequence)"", it));
    }

    public static Gen<String> alphanumeric(int minLength, int maxLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (maxLength < minLength) {
            throw new IllegalArgumentException("maxLength < minLength");
        }
        return ListGen.arbitrary(alphanumeric, minLength, maxLength).map(it -> String.join((CharSequence)"", it));
    }

    private static String blank(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        return String.join((CharSequence)"", Collections.nCopies(length, " "));
    }

    @Override
    public Supplier<String> apply(Random gen) {
        Objects.requireNonNull(gen);
        return StrGen.genStr(gen, this.length);
    }

    private static /* synthetic */ String lambda$genStr$2(Supplier chars) {
        return StrGen.chars2String((List)chars.get());
    }
}

