/*
 * Decompiled with CFR 0.152.
 */
package fun.optic;

import fun.optic.Option;
import fun.optic.Prism;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class Lens<S, O> {
    public final Function<S, O> get;
    public final Function<O, Function<S, S>> set;
    public final Function<Predicate<O>, Function<S, Optional<O>>> find;
    public final Function<Predicate<O>, Predicate<S>> exists;
    public final Function<Function<O, O>, Function<S, S>> modify;

    public Lens(Function<S, O> get, Function<O, Function<S, S>> set) {
        this.set = Objects.requireNonNull(set);
        this.get = Objects.requireNonNull(get);
        this.modify = f -> json -> ((Function)set.apply(f.apply(get.apply(json)))).apply(json);
        this.find = predicate -> s -> predicate.test(get.apply(s)) ? Optional.of(get.apply(s)) : Optional.empty();
        this.exists = predicate -> s -> predicate.test(get.apply(s));
    }

    public <T> Option<S, T> compose(Prism<O, T> prism) {
        Objects.requireNonNull(prism);
        return new Option<Object, Object>(json -> Objects.requireNonNull(prism).getOptional.apply(this.get.apply(json)), value -> json -> this.set.apply(prism.reverseGet.apply(Objects.requireNonNull(value))).apply(Objects.requireNonNull(json)));
    }

    public <B> Lens<S, B> compose(Lens<O, B> other) {
        Objects.requireNonNull(other);
        return new Lens<S, Object>(this.get.andThen(other.get), b -> s -> {
            O o = this.get.apply(Objects.requireNonNull(s));
            if (o == null) {
                return s;
            }
            S newO = other.set.apply(Objects.requireNonNull(b)).apply(o);
            return this.set.apply(newO).apply(s);
        });
    }

    public <B> Option<S, B> compose(Option<O, B> option) {
        return new Option<Object, Object>(s -> option.get.apply(this.get.apply(s)), b -> s -> {
            O c = this.get.apply(s);
            if (c == null) {
                return s;
            }
            Object d = option.set.apply(b).apply(c);
            return this.set.apply(d).apply(s);
        });
    }
}

