/*
 * Decompiled with CFR 0.152.
 */
package fun.optic;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class Option<S, T> {
    public final Function<S, Optional<T>> get;
    public final Function<T, Function<S, S>> set;
    public final Function<Function<T, T>, Function<S, S>> modify;

    public Option(Function<S, Optional<T>> get, Function<T, Function<S, S>> set) {
        this.get = Objects.requireNonNull(get);
        this.set = Objects.requireNonNull(set);
        this.modify = f -> json -> {
            Optional value = (Optional)get.apply(json);
            if (!value.isPresent()) {
                return json;
            }
            return ((Function)set.apply(f.apply(value.get()))).apply(json);
        };
    }

    public <F> Option<S, F> compose(Option<T, F> other) {
        Objects.requireNonNull(other);
        return new Option<Object, Object>(s -> {
            Optional<T> t = this.get.apply(s);
            if (t.isPresent()) {
                return other.get.apply(t.get());
            }
            return Optional.empty();
        }, f -> s -> {
            Optional<T> t = this.get.apply(s);
            if (t.isPresent()) {
                return this.set.apply(other.set.apply(f).apply(t.get())).apply(s);
            }
            return s;
        });
    }
}

