/*
 * Decompiled with CFR 0.152.
 */
package fun.optic;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class Prism<S, T> {
    public final Function<S, Optional<T>> getOptional;
    public final Function<T, S> reverseGet;
    public final Predicate<S> isEmpty;
    public final Predicate<S> nonEmpty;
    public final Function<Function<T, T>, Function<S, S>> modify;
    public final Function<Function<T, T>, Function<S, Optional<S>>> modifyOpt;
    public final Function<Predicate<T>, Function<S, Optional<T>>> find;
    public final Function<Predicate<T>, Predicate<S>> exists;
    public final Function<Predicate<T>, Predicate<S>> all;

    public Prism(Function<S, Optional<T>> getOptional, Function<T, S> reverseGet) {
        this.getOptional = Objects.requireNonNull(getOptional);
        this.reverseGet = Objects.requireNonNull(reverseGet);
        this.modify = f -> {
            Objects.requireNonNull(f);
            return v -> {
                Optional opt = (Optional)getOptional.apply(v);
                if (opt.isPresent()) {
                    return reverseGet.apply(f.apply(opt.get()));
                }
                return v;
            };
        };
        this.modifyOpt = f -> v -> {
            Optional opt = (Optional)getOptional.apply(v);
            return opt.map(t -> reverseGet.apply(f.apply(t)));
        };
        this.isEmpty = target -> !((Optional)getOptional.apply(target)).isPresent();
        this.nonEmpty = target -> ((Optional)getOptional.apply(target)).isPresent();
        this.find = predicate -> v -> ((Optional)getOptional.apply(v)).filter(predicate);
        this.exists = predicate -> v -> ((Optional)getOptional.apply(v)).filter(predicate).isPresent();
        this.all = predicate -> v -> {
            Optional value = (Optional)getOptional.apply(v);
            return value.map(predicate::test).orElse(true);
        };
    }
}

