/*
 * Decompiled with CFR 0.152.
 */
package fun.tuple;

import java.util.Objects;

public final class Pair<A, B> {
    private final A first;
    private final B second;

    private Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(Objects.requireNonNull(first), Objects.requireNonNull(second));
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ')';
    }
}

