/*
 * Decompiled with CFR 0.152.
 */
package fun.tuple;

import java.util.Objects;

public final class Triple<A, B, C> {
    private final A first;
    private final B second;
    private final C third;

    private Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(Objects.requireNonNull(first), Objects.requireNonNull(second), Objects.requireNonNull(third));
    }

    public A first() {
        return this.first;
    }

    public B second() {
        return this.second;
    }

    public C third() {
        return this.third;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.first, triple.first) && Objects.equals(this.second, triple.second) && Objects.equals(this.third, triple.third);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }
}

