/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jsonvalues.JsArray;
import jsonvalues.JsBool;
import jsonvalues.JsLong;
import jsonvalues.JsNull;
import jsonvalues.JsObj;
import jsonvalues.JsStr;
import jsonvalues.JsValue;
import jsonvalues.spec.JsSpecs;
import mongovalues.JsValuesRegistry;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonValue;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;

public class Converters {
    public static final Function<JsObj, Bson> jsObj2Bson = obj -> new BsonDocumentWrapper(obj, (Encoder)JsValuesRegistry.INSTANCE.get(JsObj.class));
    public static final Function<JsArray, List<JsObj>> jsArray2ListOfJsObj = array -> {
        Set errors = JsSpecs.arrayOfObj.test(array);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(errors.toString());
        }
        ArrayList list = new ArrayList();
        array.iterator().forEachRemaining(it -> list.add(it.toJsObj()));
        return list;
    };
    public static final Function<JsArray, List<Bson>> jsArray2ListOfBson = jsArray2ListOfJsObj.andThen(list -> list.stream().map(it -> jsObj2Bson.apply(it.toJsObj())).collect(Collectors.toList()));
    public static final Function<BsonValue, String> objectId2Hex = bsonValue -> bsonValue.asObjectId().getValue().toHexString();
    public static final Function<InsertOneResult, String> insertOneResult2HexId = result -> objectId2Hex.apply(result.getInsertedId());
    public static final Function<InsertOneResult, JsObj> insertOneResult2JsObj = result -> JsObj.of((String)"insertedId", (JsValue)JsStr.of((String)insertOneResult2HexId.apply((InsertOneResult)result)), (String)"wasAcknowledged", (JsValue)JsBool.of((boolean)result.wasAcknowledged()), (String)"type", (JsValue)JsStr.of((String)result.getClass().getSimpleName()));
    public static final Function<UpdateResult, Optional<String>> updateResult2OptHexId = it -> {
        BsonValue upsertedId = it.getUpsertedId();
        if (upsertedId == null) {
            return Optional.empty();
        }
        return Optional.of(objectId2Hex.apply(upsertedId));
    };
    public static final Function<UpdateResult, JsObj> updateResult2JsObj = result -> {
        Optional<String> optStr = updateResult2OptHexId.apply((UpdateResult)result);
        return JsObj.of((String)"upsertedId", (JsValue)(optStr.isPresent() ? JsStr.of((String)optStr.get()) : JsNull.NULL), (String)"matchedCount", (JsValue)JsLong.of((long)result.getMatchedCount()), (String)"modifiedCount", (JsValue)JsLong.of((long)result.getModifiedCount()), (String)"wasAcknowledged", (JsValue)JsBool.of((boolean)result.wasAcknowledged()), (String)"type", (JsValue)JsStr.of((String)result.getClass().getSimpleName()));
    };
    public static final Function<FindIterable<JsObj>, JsObj> findIterableHead = MongoIterable::first;
    public static final Function<FindIterable<JsObj>, JsArray> findIterable2JsArray = JsArray::ofIterable;
    public static final Function<String, JsObj> str2Oid = id -> JsObj.of((String)"_id", (JsValue)JsObj.of((String)"$oid", (JsValue)JsStr.of((String)id)));
    public static final Function<InsertManyResult, JsArray> insertManyResult2JsArrayOfHexIds = result -> {
        Map map = result.getInsertedIds();
        JsArray array = JsArray.empty();
        for (Map.Entry e : map.entrySet()) {
            array = array.append((JsValue)JsStr.of((String)objectId2Hex.apply((BsonValue)e.getValue())), new JsValue[0]);
        }
        return array;
    };
    public static final Function<DeleteResult, JsObj> deleteResult2JsObj = result -> JsObj.of((String)"deleted_count", (JsValue)JsLong.of((long)result.getDeletedCount()), (String)"was_acknowledged", (JsValue)JsBool.of((boolean)result.wasAcknowledged()));
    public static final Function<AggregateIterable<JsObj>, JsArray> aggregateResult2JsArray = iter -> {
        JsArray result = JsArray.empty();
        for (JsObj obj : iter) {
            result = result.append((JsValue)obj, new JsValue[0]);
        }
        return result;
    };

    private Converters() {
    }
}

