/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect;

import java.util.Objects;
import jsonvalues.JsBool;
import jsonvalues.JsInt;
import jsonvalues.JsLong;
import jsonvalues.JsObj;
import jsonvalues.JsStr;
import jsonvalues.JsValue;
import vertx.mongodb.effect.FindMessageBuilder;

public class FindMessage {
    public static final String NO_CURSOR_TIMEOUT = "noCursorTimeout";
    public static final String HINT_STRING = "hintString";
    public static final String HINT = "hint";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String MAX_TIME = "maxTime";
    public static final String SKIP = "skip";
    public static final String LIMIT = "limit";
    public static final String COMMENT = "comment";
    public static final String FILTER = "filter";
    public static final String BATCH_SIZE = "batchSize";
    public static final String SORT = "sort";
    public static final String PROJECTION = "projection";
    public static final String MAX_AWAIT_TIME = "maxAwaitTime";
    public static final String SHOW_RECORD_ID = "showRecordId";
    public static final String PARTIAL = "partial";
    public static final String RETURN_KEY = "returnKey";
    public final JsObj filter;
    public final JsObj sort;
    public final JsObj projection;
    public final JsObj hint;
    public final JsObj max;
    public final JsObj min;
    public final String hintString;
    public final int skip;
    public final int limit;
    public final boolean showRecordId;
    public final boolean returnKey;
    public final String comment;
    public final boolean noCursorTimeout;
    public final boolean partial;
    public final int batchSize;
    public final long maxAwaitTime;
    public final long maxTime;

    FindMessage(JsObj filter, JsObj sort, JsObj projection, JsObj hint, JsObj max, JsObj min, String hintString, int skip, int limit, boolean showRecordId, boolean returnKey, String comment, boolean noCursorTimeout, boolean partial, int batchSize, long maxAwaitTime, long maxTime) {
        this.filter = Objects.requireNonNull(filter);
        this.sort = sort;
        this.projection = projection;
        this.hint = hint;
        this.max = max;
        this.min = min;
        this.hintString = hintString;
        this.skip = skip;
        this.limit = limit;
        this.showRecordId = showRecordId;
        this.returnKey = returnKey;
        this.comment = comment;
        this.noCursorTimeout = noCursorTimeout;
        this.partial = partial;
        this.batchSize = batchSize;
        this.maxAwaitTime = maxAwaitTime;
        this.maxTime = maxTime;
    }

    public static FindMessage ofFilter(JsObj filter) {
        return new FindMessageBuilder().filter(Objects.requireNonNull(filter)).create();
    }

    public static FindMessage ofFilter(JsObj filter, JsObj projection) {
        return new FindMessageBuilder().filter(Objects.requireNonNull(filter)).projection(Objects.requireNonNull(projection)).create();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindMessage that = (FindMessage)o;
        return this.skip == that.skip && this.limit == that.limit && this.showRecordId == that.showRecordId && this.returnKey == that.returnKey && this.noCursorTimeout == that.noCursorTimeout && this.partial == that.partial && this.batchSize == that.batchSize && this.maxAwaitTime == that.maxAwaitTime && this.maxTime == that.maxTime && this.filter.equals((Object)that.filter) && Objects.equals(this.sort, that.sort) && Objects.equals(this.projection, that.projection) && Objects.equals(this.hint, that.hint) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min) && Objects.equals(this.hintString, that.hintString) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort, this.projection, this.hint, this.max, this.min, this.hintString, this.skip, this.limit, this.showRecordId, this.returnKey, this.comment, this.noCursorTimeout, this.partial, this.batchSize, this.maxAwaitTime, this.maxTime);
    }

    public static FindMessage ofFilter(JsObj filter, JsObj projection, JsObj sort) {
        return new FindMessageBuilder().filter(Objects.requireNonNull(filter)).projection(Objects.requireNonNull(projection)).sort(Objects.requireNonNull(sort)).create();
    }

    public JsObj toJsObj() {
        JsObj options = JsObj.empty();
        options = options.set(FILTER, (JsValue)this.filter);
        options.set(LIMIT, (JsValue)JsInt.of((int)this.limit));
        options = options.set(BATCH_SIZE, (JsValue)JsInt.of((int)this.batchSize));
        options = options.set(MAX_AWAIT_TIME, (JsValue)JsLong.of((long)this.maxAwaitTime));
        options = options.set(MAX_TIME, (JsValue)JsLong.of((long)this.maxTime));
        options = options.set(SKIP, (JsValue)JsInt.of((int)this.skip));
        options = options.set(LIMIT, (JsValue)JsInt.of((int)this.limit));
        options = options.set(NO_CURSOR_TIMEOUT, (JsValue)JsBool.of((boolean)this.noCursorTimeout));
        options = options.set(SHOW_RECORD_ID, (JsValue)JsBool.of((boolean)this.showRecordId));
        options = options.set(PARTIAL, (JsValue)JsBool.of((boolean)this.partial));
        options = options.set(RETURN_KEY, (JsValue)JsBool.of((boolean)this.returnKey));
        if (this.hintString != null) {
            options = options.set(HINT_STRING, (JsValue)JsStr.of((String)this.hintString));
        }
        if (this.hint != null) {
            options = options.set(HINT, (JsValue)this.hint);
        }
        if (this.projection != null) {
            options = options.set(PROJECTION, (JsValue)this.projection);
        }
        if (this.sort != null) {
            options = options.set(SORT, (JsValue)this.sort);
        }
        if (this.comment != null) {
            options = options.set(COMMENT, (JsValue)JsStr.of((String)this.comment));
        }
        if (this.max != null) {
            options = options.set(MAX, (JsValue)this.max);
        }
        if (this.min != null) {
            options = options.set(MIN, (JsValue)this.min);
        }
        return options;
    }
}

