/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jsonvalues.JsObj;
import vertx.mongodb.effect.FindMessage;

public class FindMessageBuilder {
    private JsObj filter;
    private JsObj sort;
    private JsObj projection;
    private JsObj hint;
    private JsObj max;
    private JsObj min;
    private String hintString;
    private int skip = 0;
    private int limit = 0;
    private boolean showRecordId;
    private boolean returnKey;
    private String comment;
    private boolean noCursorTimeout;
    private boolean partial;
    private int batchSize = 100;
    private long maxAwaitTime = 0L;
    private long maxTime = 0L;

    public FindMessageBuilder filter(JsObj filter) {
        this.filter = filter;
        return this;
    }

    public FindMessageBuilder sort(JsObj sort) {
        this.sort = sort;
        return this;
    }

    public FindMessageBuilder projection(JsObj projection) {
        this.projection = projection;
        return this;
    }

    public FindMessageBuilder hint(JsObj hint) {
        this.hint = hint;
        return this;
    }

    public FindMessageBuilder max(JsObj max) {
        this.max = max;
        return this;
    }

    public FindMessageBuilder min(JsObj min) {
        this.min = min;
        return this;
    }

    public FindMessageBuilder hintString(String hintString) {
        this.hintString = hintString;
        return this;
    }

    public FindMessageBuilder skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException("skip is < 0");
        }
        this.skip = skip;
        return this;
    }

    public FindMessageBuilder limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit is < 0");
        }
        this.limit = limit;
        return this;
    }

    public FindMessageBuilder showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindMessageBuilder returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public FindMessageBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public FindMessageBuilder noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public FindMessageBuilder partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public FindMessageBuilder batchSize(int batchSize) {
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize is < 0");
        }
        this.batchSize = batchSize;
        return this;
    }

    public FindMessageBuilder maxAwaitTime(int maxAwaitTime, TimeUnit unit) {
        if (maxAwaitTime < 0) {
            throw new IllegalArgumentException("maxAwaitTime is < 0");
        }
        this.maxAwaitTime = Objects.requireNonNull(unit).toMillis(maxAwaitTime);
        return this;
    }

    public FindMessageBuilder maxTime(int maxTime, TimeUnit unit) {
        if (maxTime < 0) {
            throw new IllegalArgumentException("maxTime is < 0");
        }
        this.maxTime = Objects.requireNonNull(unit).toMillis(maxTime);
        return this;
    }

    public FindMessage create() {
        return new FindMessage(this.filter, this.sort, this.projection, this.hint, this.max, this.min, this.hintString, this.skip, this.limit, this.showRecordId, this.returnKey, this.comment, this.noCursorTimeout, this.partial, this.batchSize, this.maxAwaitTime, this.maxTime);
    }
}

