/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import mongovalues.JsValuesRegistry;

public class MongoVertxClient
extends AbstractVerticle {
    public Function<String, MongoDatabase> getDatabase;
    private volatile MongoClient mongoClient;
    private Function<MongoDatabase, Function<String, MongoCollection<JsObj>>> getCollectionFromMongoDB;
    private final MongoClientSettings settings;

    public final Supplier<MongoCollection<JsObj>> getCollection(String db, String collectionName) {
        return () -> {
            if (this.getDatabase == null) {
                throw new NullPointerException("getDatabase function is null. Did you deploy the MongoVertxClient verticle?!");
            }
            MongoDatabase database = this.getDatabase.apply(Objects.requireNonNull(db));
            return Objects.requireNonNull(this.getCollectionFromMongoDB).apply(database).apply(Objects.requireNonNull(collectionName));
        };
    }

    public MongoVertxClient(MongoClientSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    public MongoVertxClient(String connection) {
        ConnectionString connString = new ConnectionString(Objects.requireNonNull(connection));
        this.settings = MongoClientSettings.builder().applyConnectionString(connString).codecRegistry(JsValuesRegistry.INSTANCE).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Promise<Void> startPromise) {
        MongoClient result = this.mongoClient;
        if (result == null) {
            Class<MongoVertxClient> clazz = MongoVertxClient.class;
            synchronized (MongoVertxClient.class) {
                if (this.mongoClient == null) {
                    try {
                        this.mongoClient = result = MongoClients.create((MongoClientSettings)Objects.requireNonNull(this.settings));
                        this.getDatabase = name -> this.mongoClient.getDatabase(Objects.requireNonNull(name));
                        this.getCollectionFromMongoDB = db -> name -> Objects.requireNonNull(db).getCollection(Objects.requireNonNull(name), JsObj.class);
                        startPromise.complete();
                    }
                    catch (Exception error) {
                        startPromise.fail((Throwable)error);
                    }
                } else {
                    result = this.mongoClient;
                    startPromise.complete();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            startPromise.complete();
        }
    }
}

