/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect;

import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jsonvalues.JsObj;

public class Watcher
extends AbstractVerticle {
    public final Supplier<MongoCollection<JsObj>> collectionSupplier;
    public final Consumer<ChangeStreamIterable<JsObj>> consumer;
    private ClientSession session;

    public Watcher(Supplier<MongoCollection<JsObj>> collectionSupplier, Consumer<ChangeStreamIterable<JsObj>> consumer) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.consumer = Objects.requireNonNull(consumer);
    }

    public Watcher(Supplier<MongoCollection<JsObj>> collectionSupplier, Consumer<ChangeStreamIterable<JsObj>> consumer, ClientSession session) {
        this(collectionSupplier, consumer);
        this.session = session;
    }

    public void start(Promise<Void> promise) {
        try {
            if (this.session != null) {
                this.consumer.accept((ChangeStreamIterable<JsObj>)this.collectionSupplier.get().watch(this.session));
            } else {
                this.consumer.accept((ChangeStreamIterable<JsObj>)this.collectionSupplier.get().watch());
            }
            promise.complete();
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }
}

