/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.codecs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import java.util.concurrent.TimeUnit;
import jsonvalues.JsObj;
import vertx.mongodb.effect.FindMessage;
import vertx.mongodb.effect.FindMessageBuilder;

public class FindMessageCodec
implements MessageCodec<FindMessage, FindMessage> {
    public static final FindMessageCodec INSTANCE = new FindMessageCodec();

    private FindMessageCodec() {
    }

    public void encodeToWire(Buffer buffer, FindMessage findMessage) {
        JsObj obj = findMessage.toJsObj();
        byte[] bytes = obj.serialize();
        buffer.appendInt(bytes.length);
        buffer.appendBytes(bytes);
    }

    public FindMessage decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + length);
        JsObj options = JsObj.parse((String)new String(bytes));
        Boolean noCursorTimeout = options.getBool("noCursorTimeout");
        Boolean partial = options.getBool("partial");
        Boolean returnKey = options.getBool("returnKey");
        Boolean showRecordId = options.getBool("showRecordId");
        Integer maxTime = options.getInt("maxTime");
        Integer maxAwaitTime = options.getInt("maxAwaitTime");
        FindMessageBuilder builder = new FindMessageBuilder().batchSize(options.getInt("batchSize")).comment(options.getStr("comment")).filter(options.getObj("filter")).hint(options.getObj("hint")).limit(options.getInt("limit")).hintString(options.getStr("hintString")).max(options.getObj("max")).min(options.getObj("min")).noCursorTimeout(Boolean.TRUE.equals(noCursorTimeout)).partial(Boolean.TRUE.equals(partial)).projection(options.getObj("projection")).returnKey(Boolean.TRUE.equals(returnKey)).showRecordId(Boolean.TRUE.equals(showRecordId)).skip(options.getInt("skip")).sort(options.getObj("sort")).maxTime(maxTime, TimeUnit.MILLISECONDS).maxAwaitTime(maxAwaitTime, TimeUnit.MILLISECONDS);
        return builder.create();
    }

    public FindMessage transform(FindMessage findMessage) {
        return findMessage;
    }

    public String name() {
        return "mongo-find-message";
    }

    public byte systemCodecID() {
        return -1;
    }
}

