/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.codecs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import jsonvalues.JsObj;
import vertx.mongodb.effect.UpdateMessage;

public class UpdateMessageCodec
implements MessageCodec<UpdateMessage, UpdateMessage> {
    public static final UpdateMessageCodec INSTANCE = new UpdateMessageCodec();

    private UpdateMessageCodec() {
    }

    public void encodeToWire(Buffer buffer, UpdateMessage updateMessage) {
        byte[] filter = updateMessage.filter.serialize();
        byte[] update = updateMessage.update.serialize();
        buffer.appendInt(filter.length);
        buffer.appendInt(update.length);
        buffer.appendBytes(filter);
        buffer.appendBytes(update);
    }

    public UpdateMessage decodeFromWire(int pos, Buffer buffer) {
        int filterLength = buffer.getInt(pos);
        int updateLength = buffer.getInt(pos += 4);
        String filter = buffer.getString(pos += 4, pos + filterLength);
        String update = buffer.getString(pos += filterLength, pos + updateLength);
        return new UpdateMessage(JsObj.parse((String)filter), JsObj.parse((String)update));
    }

    public UpdateMessage transform(UpdateMessage message) {
        return message;
    }

    public String name() {
        return "mongo-update-docs";
    }

    public byte systemCodecID() {
        return -1;
    }
}

