/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsArray;
import jsonvalues.JsObj;
import org.bson.conversions.Bson;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.functions.Functions;

public class Aggregate<O>
implements \u03bbc<JsArray, O> {
    public final Function<AggregateIterable<JsObj>, O> resultConverter;
    public final Supplier<MongoCollection<JsObj>> collectionSupplier;

    public Aggregate(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<AggregateIterable<JsObj>, O> resultConverter) {
        this.resultConverter = resultConverter;
        this.collectionSupplier = collectionSupplier;
    }

    public Val<O> apply(MultiMap context, JsArray m) {
        return Cons.of(() -> {
            try {
                List<Bson> pipeline = Converters.jsArray2ListOfBson.apply(m);
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply((AggregateIterable<JsObj>)collection.aggregate(pipeline)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

