/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import org.bson.conversions.Bson;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.functions.Functions;

public class Count
implements \u03bbc<JsObj, Long> {
    private final CountOptions options;
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private static final CountOptions DEFAULT_OPTIONS = new CountOptions();

    public Count(Supplier<MongoCollection<JsObj>> collectionSupplier, CountOptions options) {
        this.options = Objects.requireNonNull(options);
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
    }

    public Count(Supplier<MongoCollection<JsObj>> collectionSupplier) {
        this.options = DEFAULT_OPTIONS;
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
    }

    public Val<Long> apply(MultiMap context, JsObj query) {
        if (query == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("query is null"));
        }
        return Cons.of(() -> {
            try {
                Bson queryBson = Converters.jsObj2Bson.apply(Objects.requireNonNull(query));
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture((Object)collection.countDocuments(queryBson, this.options));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

