/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.result.DeleteResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.functions.Functions;

public class DeleteOne<O>
implements \u03bbc<JsObj, O> {
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final Function<DeleteResult, O> resultConverter;
    private final DeleteOptions options;
    private static final DeleteOptions DEFAULT_OPTIONS = new DeleteOptions();

    public DeleteOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<DeleteResult, O> resultConverter, DeleteOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.resultConverter = Objects.requireNonNull(resultConverter);
        this.options = Objects.requireNonNull(options);
    }

    public DeleteOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<DeleteResult, O> resultConverter) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.resultConverter = Objects.requireNonNull(resultConverter);
        this.options = DEFAULT_OPTIONS;
    }

    public Val<O> apply(MultiMap context, JsObj query) {
        if (query == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("query is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply(collection.deleteOne(Converters.jsObj2Bson.apply(Objects.requireNonNull(query)), this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

