/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import org.bson.conversions.Bson;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.FindMessage;
import vertx.mongodb.effect.functions.Functions;

class Find<O>
implements \u03bbc<FindMessage, O> {
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final Function<FindIterable<JsObj>, O> converter;

    public Find(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<FindIterable<JsObj>, O> converter) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.converter = Objects.requireNonNull(converter);
    }

    public Val<O> apply(MultiMap context, FindMessage message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                Bson hint = message.hint != null ? Converters.jsObj2Bson.apply(message.hint) : null;
                Bson max = message.max != null ? Converters.jsObj2Bson.apply(message.max) : null;
                Bson projection = message.projection != null ? Converters.jsObj2Bson.apply(message.projection) : null;
                Bson sort = message.sort != null ? Converters.jsObj2Bson.apply(message.sort) : null;
                Bson min = message.min != null ? Converters.jsObj2Bson.apply(message.min) : null;
                MongoCollection<JsObj> obj = this.collectionSupplier.get();
                O result = this.converter.apply((FindIterable<JsObj>)Objects.requireNonNull(obj).find(Converters.jsObj2Bson.apply(message.filter)).hint(hint).max(max).projection(projection).sort(sort).min(min).batchSize(message.batchSize).comment(message.comment).hintString(message.hintString).limit(message.limit).skip(message.skip).maxTime(message.maxTime, TimeUnit.MILLISECONDS).maxAwaitTime(message.maxAwaitTime, TimeUnit.MILLISECONDS).partial(message.partial).showRecordId(message.showRecordId).noCursorTimeout(message.noCursorTimeout));
                return Future.succeededFuture(result);
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

