/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.functions.Functions;

public class FindOneAndDelete
implements \u03bbc<JsObj, JsObj> {
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final FindOneAndDeleteOptions options;
    private static final FindOneAndDeleteOptions DEFAULT_OPTIONS = new FindOneAndDeleteOptions();

    public FindOneAndDelete(Supplier<MongoCollection<JsObj>> collectionSupplier) {
        this(collectionSupplier, DEFAULT_OPTIONS);
    }

    public FindOneAndDelete(Supplier<MongoCollection<JsObj>> collectionSupplier, FindOneAndDeleteOptions options) {
        this.options = Objects.requireNonNull(options);
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
    }

    public Val<JsObj> apply(MultiMap context, JsObj query) {
        if (query == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("query is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = this.collectionSupplier.get();
                return Future.succeededFuture((Object)((JsObj)collection.findOneAndDelete(Converters.jsObj2Bson.apply(query), this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

