/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.UpdateMessage;
import vertx.mongodb.effect.functions.Functions;

public class FindOneAndReplace
implements \u03bbc<UpdateMessage, JsObj> {
    private final FindOneAndReplaceOptions options;
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private static final FindOneAndReplaceOptions DEFAULT_OPTIONS = new FindOneAndReplaceOptions();

    public FindOneAndReplace(Supplier<MongoCollection<JsObj>> collectionSupplier, FindOneAndReplaceOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = Objects.requireNonNull(options);
    }

    public FindOneAndReplace(Supplier<MongoCollection<JsObj>> collectionSupplier) {
        this(collectionSupplier, DEFAULT_OPTIONS);
    }

    public Val<JsObj> apply(MultiMap context, UpdateMessage message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture((Object)((JsObj)collection.findOneAndReplace(Converters.jsObj2Bson.apply(message.filter), (Object)message.update, this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

