/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.UpdateMessage;
import vertx.mongodb.effect.functions.Functions;

public class FindOneAndUpdate
implements \u03bbc<UpdateMessage, JsObj> {
    private final FindOneAndUpdateOptions options;
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private static final FindOneAndUpdateOptions DEFAULT_OPTIONS = new FindOneAndUpdateOptions();

    public FindOneAndUpdate(Supplier<MongoCollection<JsObj>> collectionSupplier) {
        this(collectionSupplier, DEFAULT_OPTIONS);
    }

    public FindOneAndUpdate(Supplier<MongoCollection<JsObj>> collectionSupplier, FindOneAndUpdateOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = Objects.requireNonNull(options);
    }

    public Val<JsObj> apply(MultiMap context, UpdateMessage message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = this.collectionSupplier.get();
                return Future.succeededFuture((Object)((JsObj)collection.findOneAndUpdate(Converters.jsObj2Bson.apply(message.filter), Converters.jsObj2Bson.apply(message.update), this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

