/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import java.util.Arrays;
import java.util.function.Function;

class Functions {
    static final Function<Throwable, ReplyException> toMongoValExc = exc -> {
        switch (exc.getClass().getSimpleName()) {
            case "MongoSocketReadTimeoutException": {
                return new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 5001, Functions.getMessage(exc));
            }
            case "MongoTimeoutException": {
                return new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 5000, Functions.getMessage(exc));
            }
        }
        return new ReplyException(ReplyFailure.RECIPIENT_FAILURE, 5999, Functions.getMessage(exc));
    };

    Functions() {
    }

    private static String getMessage(Throwable e) {
        return e.getStackTrace().length == 0 ? e.toString() : e.toString() + "@" + Arrays.toString(e.getStackTrace());
    }
}

