/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.result.InsertManyResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsArray;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.functions.Functions;

public class InsertMany<R>
implements \u03bbc<JsArray, R> {
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final InsertManyOptions options;
    private final Function<InsertManyResult, R> resultConverter;

    public InsertMany(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<InsertManyResult, R> resultConverter) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = new InsertManyOptions();
        this.resultConverter = Objects.requireNonNull(resultConverter);
    }

    public InsertMany(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<InsertManyResult, R> resultConverter, InsertManyOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = Objects.requireNonNull(options);
        this.resultConverter = Objects.requireNonNull(resultConverter);
    }

    public Val<R> apply(MultiMap context, JsArray message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                List<JsObj> docs = Converters.jsArray2ListOfJsObj.apply(message);
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply(collection.insertMany(docs, this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

