/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.result.InsertOneResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.functions.Functions;

public class InsertOne<R>
implements \u03bbc<JsObj, R> {
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final InsertOneOptions options;
    private final Function<InsertOneResult, R> resultConverter;
    private static final InsertOneOptions DEFAULT_OPTIONS = new InsertOneOptions();

    public InsertOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<InsertOneResult, R> resultConverter) {
        this(collectionSupplier, resultConverter, DEFAULT_OPTIONS);
    }

    public InsertOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<InsertOneResult, R> resultConverter, InsertOneOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = Objects.requireNonNull(options);
        this.resultConverter = Objects.requireNonNull(resultConverter);
    }

    public Val<R> apply(MultiMap context, JsObj message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply(collection.insertOne((Object)message, this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

