/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.UpdateResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.UpdateMessage;
import vertx.mongodb.effect.functions.Functions;

public class ReplaceOne<O>
implements \u03bbc<UpdateMessage, O> {
    private final Function<UpdateResult, O> resultConverter;
    private final Supplier<MongoCollection<JsObj>> collectionSupplier;
    private final ReplaceOptions options;
    public static final ReplaceOptions DEFAULT_OPTIONS = new ReplaceOptions();

    public ReplaceOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<UpdateResult, O> resultConverter, ReplaceOptions options) {
        this.resultConverter = Objects.requireNonNull(resultConverter);
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.options = Objects.requireNonNull(options);
    }

    public ReplaceOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<UpdateResult, O> resultConverter) {
        this(collectionSupplier, resultConverter, DEFAULT_OPTIONS);
    }

    public Val<O> apply(MultiMap context, UpdateMessage message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply(collection.replaceOne(Converters.jsObj2Bson.apply(message.filter), (Object)message.update, this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

