/*
 * Decompiled with CFR 0.152.
 */
package vertx.mongodb.effect.functions;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import jsonvalues.JsObj;
import vertx.effect.Val;
import vertx.effect.exp.Cons;
import vertx.effect.\u03bbc;
import vertx.mongodb.effect.Converters;
import vertx.mongodb.effect.UpdateMessage;
import vertx.mongodb.effect.functions.Functions;

public class UpdateOne<O>
implements \u03bbc<UpdateMessage, O> {
    public final Supplier<MongoCollection<JsObj>> collectionSupplier;
    public final Function<UpdateResult, O> resultConverter;
    public final UpdateOptions options;
    private static final UpdateOptions DEFAULT_OPTIONS = new UpdateOptions();

    public UpdateOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<UpdateResult, O> resultConverter) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.resultConverter = Objects.requireNonNull(resultConverter);
        this.options = DEFAULT_OPTIONS;
    }

    public UpdateOne(Supplier<MongoCollection<JsObj>> collectionSupplier, Function<UpdateResult, O> resultConverter, UpdateOptions options) {
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier);
        this.resultConverter = Objects.requireNonNull(resultConverter);
        this.options = Objects.requireNonNull(options);
    }

    public Val<O> apply(MultiMap context, UpdateMessage message) {
        if (message == null) {
            return Cons.failure((Throwable)new IllegalArgumentException("message is null"));
        }
        return Cons.of(() -> {
            try {
                MongoCollection<JsObj> collection = Objects.requireNonNull(this.collectionSupplier.get());
                return Future.succeededFuture(this.resultConverter.apply(collection.updateOne(Converters.jsObj2Bson.apply(message.filter), Converters.jsObj2Bson.apply(message.update), this.options)));
            }
            catch (Exception exc) {
                return Future.failedFuture((Throwable)((Throwable)Functions.toMongoValExc.apply(exc)));
            }
        });
    }
}

