/*
 * Decompiled with CFR 0.152.
 */
package com.github.isopropylcyanide.asyncmetrics.interceptor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.github.isopropylcyanide.asyncmetrics.annotation.AsyncExceptionMetered;
import com.github.isopropylcyanide.asyncmetrics.exception.AdvisedMethodException;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;

@Singleton
public final class AsyncExceptionMeteredInterceptor
implements MethodInterceptor {
    private final MetricRegistry metricRegistry;

    public AsyncExceptionMeteredInterceptor(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String metric = this.getMetricName(invocation);
        Meter exceptionMeter = this.metricRegistry.meter(metric);
        CompletableFuture future = (CompletableFuture)invocation.proceed();
        return future.handle((resp, error) -> {
            if (null != error) {
                exceptionMeter.mark();
                throw new AdvisedMethodException(metric, (Throwable)error);
            }
            return resp;
        });
    }

    private String getMetricName(MethodInvocation invocation) {
        String declaringClassName = invocation.getMethod().getDeclaringClass().getName();
        Method method = invocation.getMethod();
        String name = method.getAnnotation(AsyncExceptionMetered.class).name();
        String suffix = method.getAnnotation(AsyncExceptionMetered.class).suffix();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return MetricRegistry.name((String)declaringClassName, (String[])new String[]{name, suffix});
        }
        return MetricRegistry.name((String)declaringClassName, (String[])new String[]{method.getName(), suffix});
    }
}

