/*
 * Decompiled with CFR 0.152.
 */
package com.github.isopropylcyanide.asyncmetrics.interceptor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.github.isopropylcyanide.asyncmetrics.annotation.AsyncMetered;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;

@Singleton
public final class AsyncMeteredInterceptor
implements MethodInterceptor {
    private final MetricRegistry metricRegistry;

    public AsyncMeteredInterceptor(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String metric = this.getMetricName(invocation);
        Meter meter = this.metricRegistry.meter(metric);
        CompletableFuture future = (CompletableFuture)invocation.proceed();
        future.thenRun(() -> ((Meter)meter).mark());
        return future;
    }

    private String getMetricName(MethodInvocation invocation) {
        String declaringClassName = invocation.getMethod().getDeclaringClass().getName();
        Method method = invocation.getMethod();
        String suffix = method.getAnnotation(AsyncMetered.class).suffix();
        String name = method.getAnnotation(AsyncMetered.class).name();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return MetricRegistry.name((String)declaringClassName, (String[])new String[]{name, suffix});
        }
        return MetricRegistry.name((String)declaringClassName, (String[])new String[]{method.getName(), suffix});
    }
}

