/*
 * Decompiled with CFR 0.152.
 */
package com.github.isopropylcyanide.asyncmetrics.interceptor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.isopropylcyanide.asyncmetrics.annotation.AsyncTimed;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;

@Singleton
public final class AsyncTimedInterceptor
implements MethodInterceptor {
    private final MetricRegistry metricRegistry;

    public AsyncTimedInterceptor(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String metric = this.getMetricName(invocation);
        Timer timer = this.metricRegistry.timer(metric);
        Timer.Context context = timer.time();
        CompletableFuture future = (CompletableFuture)invocation.proceed();
        future.thenRun(() -> ((Timer.Context)context).stop());
        return future;
    }

    private String getMetricName(MethodInvocation invocation) {
        String declaringClassName = invocation.getMethod().getDeclaringClass().getName();
        Method method = invocation.getMethod();
        String name = method.getAnnotation(AsyncTimed.class).name();
        String suffix = method.getAnnotation(AsyncTimed.class).suffix();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return MetricRegistry.name((String)declaringClassName, (String[])new String[]{name, suffix});
        }
        return MetricRegistry.name((String)declaringClassName, (String[])new String[]{method.getName(), suffix});
    }
}

