/*
 * Decompiled with CFR 0.152.
 */
package com.ispong.oxygen.wechatgo.config;

import com.ispong.oxygen.wechatgo.cache.WeChatTokenGenerator;
import com.ispong.oxygen.wechatgo.cache.WechatgoTokenCache;
import com.ispong.oxygen.wechatgo.controller.WechatgoController;
import com.ispong.oxygen.wechatgo.handler.WechatgoEventHandler;
import com.ispong.oxygen.wechatgo.pojo.properties.WechatgoProperties;
import com.ispong.oxygen.wechatgo.service.WechatgoService;
import com.ispong.oxygen.wechatgo.service.impl.WechatgoServiceImpl;
import com.ispong.oxygen.wechatgo.template.WechatgoTemplate;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;

@EnableCaching
@EnableConfigurationProperties(value={WechatgoProperties.class})
public class WechatgoAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WechatgoAutoConfiguration.class);
    @Resource
    private WechatgoEventHandler wechatgoEventHandler;
    private final WechatgoProperties wechatgoProperties;

    public WechatgoAutoConfiguration(WechatgoProperties wechatgoProperties) {
        this.wechatgoProperties = wechatgoProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={WechatgoEventHandler.class})
    public WechatgoEventHandler initWechatgoEventHandler() {
        log.debug("init WechatgoEventHandler");
        return new WechatgoEventHandler(){};
    }

    @Bean
    @ConditionalOnClass(value={WechatgoAutoConfiguration.class})
    public void initWechatgoBanner() {
        log.info("welcome to use oxygen-wechatgo");
    }

    @Bean
    @ConditionalOnClass(value={WechatgoAutoConfiguration.class})
    public WechatgoTokenCache initWechatgoTokenCache() {
        log.debug("init wechatgo cache");
        return new WechatgoTokenCache();
    }

    @Bean
    @ConditionalOnBean(value={WechatgoAutoConfiguration.class})
    public WechatgoServiceImpl initWechatgoServiceImpl() {
        log.debug("init wechatgo service");
        return new WechatgoServiceImpl(this.wechatgoProperties, this.wechatgoEventHandler);
    }

    @Bean
    @ConditionalOnBean(value={WechatgoService.class})
    public WeChatTokenGenerator initWechatgoToken() {
        log.debug("init wechatgo token");
        return new WeChatTokenGenerator();
    }

    @Bean
    @ConditionalOnBean(value={WechatgoService.class})
    public WechatgoController initWechatgoController() {
        log.debug("init wechatgo controller");
        return new WechatgoController();
    }

    @Bean
    @ConditionalOnBean(value={WechatgoTokenCache.class})
    public WechatgoTemplate initWechatgoTemplate() {
        log.debug("init wechatgo template");
        return new WechatgoTemplate();
    }
}

