/*
 * Decompiled with CFR 0.152.
 */
package com.ispong.oxygen.wechatgo.controller;

import com.ispong.oxygen.common.xml.XmlUtils;
import com.ispong.oxygen.wechatgo.exception.WechatgoException;
import com.ispong.oxygen.wechatgo.pojo.entity.WeChatEventBody;
import com.ispong.oxygen.wechatgo.service.WechatgoService;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"wechatgo"})
public class WechatgoController {
    private static final Logger log = LoggerFactory.getLogger(WechatgoController.class);
    @Resource
    private WechatgoService wechatgoService;

    @GetMapping(value={"/wechatServer"})
    public String weChatAuthentication(@RequestParam(value="echostr") String echostr, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="signature") String signature) {
        log.debug("wechat go to auth");
        if (this.wechatgoService.checkWeChat(nonce, timestamp, signature).booleanValue()) {
            return echostr;
        }
        throw new WechatgoException("not wechat request");
    }

    @PostMapping(value={"/wechatServer"})
    public void weChatListen(HttpServletRequest httpServletRequest) {
        log.debug("receive wechat event");
        try {
            WeChatEventBody weChatEventBody = (WeChatEventBody)XmlUtils.parseInputStreamXml((InputStream)httpServletRequest.getInputStream(), WeChatEventBody.class);
            this.wechatgoService.handlerWechatEvent(weChatEventBody);
        }
        catch (IOException e) {
            throw new WechatgoException("has no inputStream");
        }
    }
}

