/*
 * Decompiled with CFR 0.152.
 */
package com.ispong.oxygen.wechatgo.service.impl;

import com.ispong.oxygen.common.http.HttpClientUtils;
import com.ispong.oxygen.wechatgo.exception.WechatgoException;
import com.ispong.oxygen.wechatgo.handler.WechatgoEventHandler;
import com.ispong.oxygen.wechatgo.pojo.entity.WeChatAccessToken;
import com.ispong.oxygen.wechatgo.pojo.entity.WeChatEventBody;
import com.ispong.oxygen.wechatgo.pojo.properties.WechatgoProperties;
import com.ispong.oxygen.wechatgo.service.WechatgoService;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatgoServiceImpl
implements WechatgoService {
    private static final Logger log = LoggerFactory.getLogger(WechatgoServiceImpl.class);
    private final WechatgoEventHandler wechatgoEventHandler;
    private final WechatgoProperties wechatgoProperties;

    public WechatgoServiceImpl(WechatgoProperties wechatgoProperties, WechatgoEventHandler wechatgoEventHandler) {
        this.wechatgoEventHandler = wechatgoEventHandler;
        this.wechatgoProperties = wechatgoProperties;
    }

    @Override
    public WeChatAccessToken getAccessToken() {
        WeChatAccessToken weChatAccessToken;
        HashMap<String, String> requestMap = new HashMap<String, String>(3);
        requestMap.put("grant_type", "client_credential");
        requestMap.put("appid", this.wechatgoProperties.getAppId());
        requestMap.put("secret", this.wechatgoProperties.getAppSecret());
        try {
            weChatAccessToken = (WeChatAccessToken)HttpClientUtils.doGet((String)(this.wechatgoProperties.getUrl() + "/cgi-bin/token"), requestMap, WeChatAccessToken.class);
        }
        catch (IOException e) {
            throw new WechatgoException("get wechat server token fail");
        }
        switch (weChatAccessToken.getErrCode()) {
            case -1: {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.getAccessToken();
            }
            case 0: {
                log.debug("wechat token" + weChatAccessToken);
                return weChatAccessToken;
            }
        }
        throw new WechatgoException(weChatAccessToken.getErrMsg());
    }

    @Override
    public Boolean checkWeChat(String nonce, String timestamp, String signature) {
        String token = this.wechatgoProperties.getToken();
        if (token == null) {
            throw new WechatgoException("please config wechatgo properties : 'token'");
        }
        Object[] strings = new String[]{token, timestamp, nonce};
        Arrays.sort(strings);
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(((String)strings[0] + (String)strings[1] + (String)strings[2]).getBytes());
            byte[] digest = sha1.digest();
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            char[] hashcode = new char[digest.length * 2];
            int index = 0;
            for (byte b : digest) {
                hashcode[index++] = hexDigits[b >>> 4 & 0xF];
                hashcode[index++] = hexDigits[b & 0xF];
            }
            log.debug("hashcode" + new String(hashcode) + "--signature" + signature);
            return signature.equals(new String(hashcode));
        }
        catch (NoSuchAlgorithmException e) {
            throw new WechatgoException("sha1 parse fail");
        }
    }

    @Override
    public void handlerWechatEvent(WeChatEventBody weChatEventBody) {
        switch (String.valueOf(weChatEventBody.getEvent())) {
            case "subscribe": {
                log.debug("event subscribe");
                this.wechatgoEventHandler.subscribeEvent(weChatEventBody);
                break;
            }
            case "unsubscribe": {
                log.debug("event unsubscribe");
                this.wechatgoEventHandler.unsubscribeEvent(weChatEventBody);
                break;
            }
            case "TEMPLATESENDJOBFINISH": {
                log.debug("event send template success");
                this.wechatgoEventHandler.sendMsgTemplateResponse(weChatEventBody);
                break;
            }
            default: {
                log.debug("event nothing");
            }
        }
    }
}

